package org.jeecg.modules.iost.API.TimedTask;

import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.API.ExternalInterface.MaterialinventoryApi;
import org.jeecg.modules.iost.API.service.pojo.IMaterialinventoryPojoService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.ParseException;

@Slf4j
@Component
@EnableScheduling
/**
 * 重点 材料同步定时器
 */
public class MaterialinventoryTimed implements Job {
    @Autowired
    private IMaterialinventoryPojoService iMaterialinventoryService;



    /**设置定时器功能
     * */
//    @Scheduled(cron = "0 0 1 * * ?")//cron表达式每天凌晨一点
//     @Scheduled(fixedDelay = 1000*60)
    public void Materialinventory() throws IOException, ParseException {
         iMaterialinventoryService.synchronization(null);
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            iMaterialinventoryService.synchronization(null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
