package org.jeecg.modules.iost.API.TimedTask;

import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.API.service.pojo.IProductinventoryPojoService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.ParseException;

/**
 * 产成品同步的定时器
 */
@Slf4j
@Component
@EnableScheduling
public class ProductInventoryTimed implements Job {

    @Autowired
    private IProductinventoryPojoService productInventoryService;

    /**测试定时*/
//    @Scheduled(cron = "0 0 1 * * ?")//cron表达式每天凌晨一点
//     @Scheduled(fixedDelay = 1000*60)
    public void Materialinventory() throws IOException, ParseException {
        productInventoryService.synchronization(null);

//         System.out.println("执行了");
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            productInventoryService.synchronization(null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
