package org.jeecg.modules.iost.API.Util;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HlsUtil {
    private String uuid;
    private String originUrlpath;
    private String preUrlPath;
    private String rootPath;
    private String fileName;
    private String folderPath;
    private int threadQuantity = 10;

    public HlsUtil(String originUrlpath, String preUrlPath, String rootPath){
        this.uuid = UUID.randomUUID().toString().replaceAll("-","");
        this.originUrlpath = originUrlpath;
        this.preUrlPath = preUrlPath;
        this.rootPath = rootPath;

        this.fileName = uuid+ ".mp4";

        this.folderPath = rootPath + File.separator + uuid;
        File file = new File(folderPath);
        if(!file.exists()) file.mkdirs();


    }
    public static void main(String[] args) {
        String originUrlpath = "http://localhost:8090/jintai/as/GetFile.m3u8";
//        String originUrlpath ="http://127.0.0.1:8848/dsa/EZUIKit-JavaScript/adca19a95053481a836f23da28d3f55d-8498.m3u8";
        System.out.println(originUrlpath);
        String preUrlPath = originUrlpath.substring(0, originUrlpath.lastIndexOf("/")+1);
        System.out.println(preUrlPath);
        String rootPath = "E:\\Eip";
        System.out.println(rootPath);
        String fileName = "";
        HlsUtil downLoader = new HlsUtil(originUrlpath, preUrlPath, rootPath);
//        downLoader.setThreadQuantity(10);
        try{
            fileName = downLoader.download(true);
        }
        catch (Exception e) {

        }

        if(fileName.isEmpty()){
            System.out.println("下载失败");
        }else{
            System.err.println("下载成功");
        }
    }

    public String download(boolean isAsync) throws Exception {

        String indexStr = getIndexFile();
        System.out.println(indexStr);
        List urlList = analysisIndex(indexStr);
        System.out.println(urlList);
        HashMap<Integer,String> keyFileMap = new HashMap<>();

//        if(!isAsync){
//            downLoadIndexFileAsync(urlList, keyFileMap);
//
//            while (keyFileMap.size()<urlList.size()){
//                //System.out.println("当前下载数量"+keyFileMap.size());
//                Thread.sleep(3000);
//            }
//        }else{
            keyFileMap = downLoadIndexFile(urlList);
//        }
//        System.out.println(keyFileMap);
//        return composeFile(keyFileMap);
        return "";
    }
    public String getIndexFile() throws Exception{
        URL url = new URL(originUrlpath);
        //下载资源
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(),"UTF-8"));

        String content = "" ;
        String line;
        while ((line = in.readLine()) != null) {
            content += line + "\n";
        }

        in.close();

        return content;
    }

    /* 解析索引文件 */
    public List analysisIndex(String content) throws Exception{
        Pattern pattern = Pattern.compile(".*ts");
        Matcher ma = pattern.matcher(content);

        List<String> list = new ArrayList<String>();

        while(ma.find()){
            list.add(ma.group());
        }

        return list;
    }
    /* 下载视频片段 */
    public HashMap downLoadIndexFile(List<String> urlList) throws IOException {
        HashMap<Integer,String> keyFileMap = new HashMap<>();

        for(int i =0;i<urlList.size();i++){
            String subUrlPath = urlList.get(i);
            String fileOutPath = folderPath + File.separator + i + ".ts";
            System.out.println("subUrlPath"+subUrlPath);

            System.out.println("fileOutPath"+fileOutPath);
            keyFileMap.put(i, fileOutPath);
            try{
                downloadNet(subUrlPath, fileOutPath);

                System.out.println("成功："+ (i + 1) +"/" + urlList.size());
            }catch (Exception e){
                System.err.println("失败："+ (i + 1) +"/" + urlList.size());
            }
        }

        return  keyFileMap;
    }
    private void downloadNet(String fullUrlPath, String fileOutPath) throws Exception {
        // 下载网络文件
        int byteread = 0;
        URL url = new URL(fullUrlPath);
        URLConnection conn = url.openConnection();
        InputStream inStream = conn.getInputStream();
        FileOutputStream fs = new FileOutputStream(fileOutPath);
        byte[] buffer = new byte[1204];
        while ((byteread = inStream.read(buffer)) != -1) {
            //bytesum += byteread;
            fs.write(buffer, 0, byteread);
        }
    }
}
