package org.jeecg.modules.iost.API.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.GridError;
import org.jeecg.modules.iost.API.service.*;
import org.jeecg.modules.iost.API.service.pojo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "请求国网日志")
@RestController
@RequestMapping("/API/griderror")
@Slf4j
public class GridErrorController {
    @Autowired
    private IGridErrorService gridErrorService;
    @Autowired
    private ISupplylistPojoService supplylistPojoService;
    @Autowired
    private ISalesorderPojoService salesorderPojoService;
    @Autowired
    private IProductionOrderPojoService productionOrderService;
    @Autowired
    private IProductionschedulingPojoService productionSchedulingService;
    @Autowired
    private IMaterialinventoryPojoService iMaterialinventoryService;
    @Autowired
    private IPhysicalidService physicalidService;
    @Autowired
    private IReservestockPojoService reserveStockService;
    @Autowired
    private IProductinventoryPojoService productInventoryService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "国网日志接口-分页列表查询")
    @ApiOperation(value = "国网日志接口-分页列表查询", notes = "国网日志接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(GridError gridError,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<GridError> queryWrapper = QueryGenerator.initQueryWrapper(gridError, req.getParameterMap());
        Page<GridError> page = new Page<GridError>(pageNo, pageSize);
        IPage<GridError> pageList = gridErrorService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    @PostMapping(value = "manual")
    public Result<?> synchronization(@RequestBody GridError data) throws ParseException {
        Boolean success = false;
        String id = data.getId();
        Result ok = new Result();
        JSONObject jsonObject = JSONObject.fromObject(data.getRequestjson());
        Map map = com.alibaba.fastjson.JSONObject.parseObject(String.valueOf(jsonObject), Map.class);
        if (data.getBusinessNo() != null) {
            switch (data.getBusinessNo()) {
                case 2:
                    success = supplylistPojoService.grid(map);
                    ok = Result.OK(success);
                    break;
                case 3:
                    success = salesorderPojoService.grid(map);
                    ok = Result.OK(success);
                    break;
                case 4:
                    success = productionOrderService.grid(map);
                    ok = Result.OK(success);
                    break;
                case 5:
                    success = productionSchedulingService.grid(map);
                    ok = Result.OK(success);
                    break;
                case 6:
                    success = iMaterialinventoryService.grid(map);
                    ok = Result.OK(success);
                    break;
                case 7:
                    success = physicalidService.grid(map);
                    ok = Result.OK(success);
                    break;
                case 8:
                    success = reserveStockService.grid(map);
                    ok = Result.OK(success);
                    break;
                case 9:
                    success = productInventoryService.grid(map);
                    ok = Result.OK(success);
                    break;


            }

        }
        editSuccess(success, id);
        return ok;
    }

    public Boolean editSuccess(Boolean success, String id) {
        boolean isSuccess = false;
        if (success) {
            isSuccess = gridErrorService.updateById(new GridError().setId(id).setSuccessagain(1).setSynchronization(1));
        } else {
            isSuccess = gridErrorService.updateById(new GridError().setId(id).setSuccessagain(0));
        }
        return isSuccess;
    }
}
