package org.jeecg.modules.iost.API.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import net.sf.json.JSONObject;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.GridErrorReturnProcess;
import org.jeecg.modules.iost.API.service.IGridErrorReturnProcessService;
import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

@Api(tags = "查询国网-日志")
@RestController
@RequestMapping("/API/gereturnprocess")
@Slf4j
public class GridErrorReturnProcessController {
    @Autowired
    private IGridErrorReturnProcessService gridErrorService;

    @Autowired
    private IPurchaseorderService purchaseorderService;
    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "查询国网-日志-分页列表查询")
    @ApiOperation(value = "查询国网-日志-分页列表查询", notes = "查询国网-日志-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(GridErrorReturnProcess gridError,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<GridErrorReturnProcess> queryWrapper = QueryGenerator.initQueryWrapper(gridError, req.getParameterMap());
        Page<GridErrorReturnProcess> page = new Page<GridErrorReturnProcess>(pageNo, pageSize);
        IPage<GridErrorReturnProcess> pageList = gridErrorService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    @PostMapping(value = "manual")
    public Result<?> synchronization(@RequestBody  GridErrorReturnProcess data) throws ParseException, IOException {
        Boolean success = false;
        String id=data.getId();
        Result ok = new Result();
        JSONObject jsonObject = JSONObject.fromObject(data.getRequestjson());
        Map map = com.alibaba.fastjson.JSONObject.parseObject(String.valueOf(jsonObject), Map.class);
        if (data.getBusinessNo() != null) {
            switch (data.getBusinessNo()) {
                case 1:
                    Map<String,String> synchronization = purchaseorderService.synchronization(map);
                    if (synchronization.containsKey("success")) {
                        if ("true".equals(synchronization.get("success"))) {
                            success=true;
                        }
                    }
                    ok = Result.OK(success);
                    break;
            }

        }
        editSuccess(success, id);
        return ok;
    }
    public Boolean editSuccess(Boolean success, String id) {
        boolean isSuccess = false;
        if (success) {
            isSuccess = gridErrorService.updateById(new GridErrorReturnProcess().setId(id).setSuccessagain(1).setSynchronization(1));
        } else {
            isSuccess = gridErrorService.updateById(new GridErrorReturnProcess().setId(id).setSuccessagain(0));
        }
        return isSuccess;
    }
}
