package org.jeecg.modules.iost.API.controller.kingdeejournal;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournal;
import org.jeecg.modules.iost.API.service.*;
import org.jeecg.modules.iost.API.service.pojo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

@Api(tags = "请求金蝶日志")
@RestController
@RequestMapping("/API/kingdeejournal")
@Slf4j
public class KingdeeJournalController {

    @Autowired
    private IKingdeeJournalService kingdeeJournalService;
    @Autowired
    private ISupplylistPojoService supplylistPojoService;
    @Autowired
    private ISalesorderPojoService salesorderPojoService;
    @Autowired
    private IProductionOrderPojoService productionOrderService;
    @Autowired
    private IProductionschedulingPojoService productionSchedulingService;
    @Autowired
    private IMaterialinventoryPojoService iMaterialinventoryService;
    @Autowired
    private IPhysicalidService physicalIDerrorService;
    @Autowired
    private IReservestockPojoService reserveStockService;
    @Autowired
    private IProductinventoryPojoService productInventoryService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "金蝶日志接口-分页列表查询")
    @ApiOperation(value = "金蝶日志接口-分页列表查询", notes = "金蝶日志接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(KingdeeJournal kingdeeJournal,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<KingdeeJournal> queryWrapper = QueryGenerator.initQueryWrapper(kingdeeJournal, req.getParameterMap());
        Page<KingdeeJournal> page = new Page<KingdeeJournal>(pageNo, pageSize);
        IPage<KingdeeJournal> pageList = kingdeeJournalService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     *
     */
    @PostMapping(value = "manual")
    public Result<?> synchronization(@RequestBody Map<String, String> data) throws ParseException {
        Boolean success = false;
        Result ok = new Result();
        String id = null;
        Integer businessNo = null;
        String request = null;
        id = data.get("id");
        businessNo = Integer.parseInt(data.get("businessNo"));
        request = data.get("request");
        Object filterString = null;




        if (businessNo != null) {
                filterString = JSONObject.fromObject(request).get("FilterString");
            switch (businessNo) {
                case 2:
                    success = supplylistPojoService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
                case 3:
                    success = salesorderPojoService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
                case 4:
                    success = productionOrderService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
                case 5:
                    success = productionSchedulingService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
                case 6:
                    success = iMaterialinventoryService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
                case 7:
                    success = physicalIDerrorService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
                case 8:
                    success = reserveStockService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
                case 9:
                    success = productInventoryService.synchronization(filterString);
                    ok = Result.OK(success);
                    break;
            }
        }
        editSuccess(success, id);
        return ok;
    }

    public Boolean editSuccess(Boolean success, String id) {
        boolean isSuccess = false;
        if (success) {
            isSuccess = kingdeeJournalService.updateById(new KingdeeJournal().setId(id).setSuccessagain(1).setSynchronization(1));
        } else {
            isSuccess = kingdeeJournalService.updateById(new KingdeeJournal().setId(id).setSuccessagain(0));
        }
        return isSuccess;
    }
}
