package org.jeecg.modules.iost.API.controller.kingdeejournal;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournalReturnProcess;
import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.jeecg.modules.iost.API.service.IKingdeeJournalReturnProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.Map;

@Api(tags = "保存金蝶-日志")
@RestController
@RequestMapping("/API/kingdeejournalrp")
@Slf4j
public class KingdeeJournalReturnProcessController {
    @Autowired
    private IKingdeeJournalReturnProcessService kingdeeJournalReturnProcessService;
    @Autowired
    private IPurchaseorderService purchaseorderService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "保存金蝶-日志-分页列表查询")
    @ApiOperation(value = "保存金蝶-日志-分页列表查询", notes = "保存金蝶-日志-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(KingdeeJournalReturnProcess kingdeeJournal,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<KingdeeJournalReturnProcess> queryWrapper = QueryGenerator.initQueryWrapper(kingdeeJournal, req.getParameterMap());
        Page<KingdeeJournalReturnProcess> page = new Page<KingdeeJournalReturnProcess>(pageNo, pageSize);
        IPage<KingdeeJournalReturnProcess> pageList = kingdeeJournalReturnProcessService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     *
     */
    @PostMapping(value = "manual")
    public Result<?> synchronization(@RequestBody KingdeeJournalReturnProcess data) throws ParseException {
        Boolean success = false;
        Result ok = new Result();
        String ReturnProcessId = data.getReturnProcessId();
        Integer businessNo = null;
        String id = data.getId();
        businessNo = data.getBusinessNo();
        Map<String, Object> jsonObject1 = JSONObject.fromObject(data.getReturnProcessJson());
        if (businessNo != null) {
            switch (businessNo) {
                case 1:
                    Map<String,String> manual = purchaseorderService.manual(jsonObject1, ReturnProcessId);
                    if (manual.containsKey("success")) {
                        if ("true".equals(manual.get("success"))) {
                            success=true;
                        }
                    }
                    ok = Result.OK(success);
                    break;

            }
        }
        editSuccess(success, id);
        return ok;
    }

    public Boolean editSuccess(Boolean success, String id) {
        boolean isSuccess = false;
        if (success) {
            isSuccess = kingdeeJournalReturnProcessService.updateById(new KingdeeJournalReturnProcess().setId(id).setSuccessagain(1).setSynchronization(1));
        } else {
            isSuccess = kingdeeJournalReturnProcessService.updateById(new KingdeeJournalReturnProcess().setId(id).setSuccessagain(0));
        }
        return isSuccess;
    }
}
