package org.jeecg.modules.iost.API.controller.pojo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.pojo.Materialinventory;
import org.jeecg.modules.iost.API.service.pojo.IMaterialinventoryPojoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;

@Api(tags="存放国网重点材料数据信息")
@RestController
@RequestMapping("/API/materialinventoryPojo")
@Slf4j
public class MaterialinventoryPojoController {
    @Autowired
    private IMaterialinventoryPojoService iMaterialinventoryService;
    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "国网重点材料数据信息接口-分页列表查询")
    @ApiOperation(value = "国网重点材料数据信息接口-分页列表查询", notes = "国网重点材料数据信息接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(Materialinventory materialinventory,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<Materialinventory> queryWrapper = QueryGenerator.initQueryWrapper(materialinventory, req.getParameterMap());
        Page<Materialinventory> page = new Page<Materialinventory>(pageNo, pageSize);
        IPage<Materialinventory> pageList = iMaterialinventoryService.page(page, queryWrapper);
        return Result.OK(pageList);
    }
    @AutoLog(value = "国网供应商重点原材料库存API-同步")
    @ApiOperation(value="国网供应商重点原材料库存API-同步", notes="国网供应商重点原材料库存API-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization() throws ParseException {
        Boolean synchronization = iMaterialinventoryService.synchronization(null);
        return Result.OK(synchronization);
    }
}
