package org.jeecg.modules.iost.API.controller.pojo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.pojo.Physicalid;

import org.jeecg.modules.iost.API.service.pojo.IPhysicalidService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;

@Api(tags = "实物ID明细接口")
@RestController
@RequestMapping("/API/supplier-send-physicalid")
@Slf4j
public class PhysicalidController {
    @Autowired
    private IPhysicalidService physicalidService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "实物ID信息明细-分页列表查询")
    @ApiOperation(value = "实物ID信息明细-分页列表查询", notes = "实物ID信息明细-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(Physicalid physicalid,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<Physicalid> queryWrapper = QueryGenerator.initQueryWrapper(physicalid, req.getParameterMap());
        Page<Physicalid> page = new Page<Physicalid>(pageNo, pageSize);
        IPage<Physicalid> pageList = physicalidService.page(page, queryWrapper);
        return Result.OK(pageList);
    }



    @PostMapping(value = "/synchronization")
    public Result<?> synchronization() throws ParseException {
        Boolean synchronization = physicalidService.synchronization(null);
        return Result.OK(synchronization);
    }
}
