package org.jeecg.modules.iost.API.controller.pojo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.pojo.Productinventory;
import org.jeecg.modules.iost.API.service.pojo.IProductinventoryPojoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;

@Api(tags="存放国网产成品数据信息")
@RestController
@RequestMapping("/API/productInventoryPojo")
@Slf4j
public class ProductInventoryPojoController {

    @Autowired
    private IProductinventoryPojoService productInventoryService;
    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "国网产成品数据信息接口-分页列表查询")
    @ApiOperation(value = "国网产成品数据信息接口-分页列表查询", notes = "国网产成品数据信息接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(Productinventory productinventory,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<Productinventory> queryWrapper = QueryGenerator.initQueryWrapper(productinventory, req.getParameterMap());
        Page<Productinventory> page = new Page<Productinventory>(pageNo, pageSize);
        IPage<Productinventory> pageList = productInventoryService.page(page, queryWrapper);
        return Result.OK(pageList);
    }


    /**
     * 从金蝶云即时库存中同步今天的产成品
     * @return
     */
    @AutoLog(value = "国网产成品库存信息API-同步今天的产成品")
    @ApiOperation(value="国网产成品库存信息API-同步今天的产成品", notes="国网产成品库存信息API-同步今天的产成品")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization() throws ParseException {
        Boolean synchronization = productInventoryService.synchronization(null);
        return Result.OK(synchronization);
    }
}
