package org.jeecg.modules.iost.API.controller.pojo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.pojo.ProductionOrder;
import org.jeecg.modules.iost.API.service.pojo.IProductionOrderPojoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;

@Api(tags="生产订单明细信息")
@RestController
@RequestMapping("/API/ProductionOrderPojolist")
@Slf4j
public class ProductionOrderPojoController {
    @Autowired
    private IProductionOrderPojoService productionOrderPojoService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "生产订单明细信息接口-分页列表查询")
    @ApiOperation(value = "生产订单明细信息接口-分页列表查询", notes = "生产订单明细信息接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(ProductionOrder productinventory,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<ProductionOrder> queryWrapper = QueryGenerator.initQueryWrapper(productinventory, req.getParameterMap());
        Page<ProductionOrder> page = new Page<ProductionOrder>(pageNo, pageSize);
        IPage<ProductionOrder> pageList = productionOrderPojoService.page(page, queryWrapper);
        return Result.OK(pageList);
    }
    @AutoLog(value = "生产订单API-同步至国网")
    @ApiOperation(value="生产订单API-同步至国网", notes="生产订单API-同步至国网")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization() throws ParseException {
        Boolean synchronization = productionOrderPojoService.synchronization(null);
        return Result.OK(synchronization);
    }
}
