package org.jeecg.modules.iost.API.controller.pojo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.pojo.Productionscheduling;
import org.jeecg.modules.iost.API.service.pojo.IProductionschedulingPojoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;

@Api(tags="排产计划明细信息")
@RestController
@RequestMapping("/API/ProductionschedulingPojolist")
@Slf4j
public class ProductionSchedulingPojoController {
    @Autowired
    private IProductionschedulingPojoService productionSchedulingService;

    @AutoLog(value = "排产计划明细信息接口-分页列表查询")
    @ApiOperation(value = "排产计划明细信息接口-分页列表查询", notes = "排产计划明细信息接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(Productionscheduling productinventory,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<Productionscheduling> queryWrapper = QueryGenerator.initQueryWrapper(productinventory, req.getParameterMap());
        Page<Productionscheduling> page = new Page<Productionscheduling>(pageNo, pageSize);
        IPage<Productionscheduling> pageList = productionSchedulingService.page(page, queryWrapper);
        return Result.OK(pageList);
    }
    @AutoLog(value = "排产计划API-同步至国网")
    @ApiOperation(value="排产计划API-同步至国网", notes="排产计划API-同步至国网")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization() throws ParseException {
        Boolean synchronization = productionSchedulingService.synchronization(null);
        return Result.OK(synchronization);
    }
}
