package org.jeecg.modules.iost.API.controller.pojo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.pojo.Purchaseorder;
import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

@Api(tags = "采购订单明细接口")
@RestController
@RequestMapping("/API/supplier-send-purchaseorder")
@Slf4j
public class PurchaseorderController {
    @Autowired
    IPurchaseorderService iPurchaseorderService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "采购订单明细接口-分页列表查询")
    @ApiOperation(value = "采购订单明细接口-分页列表查询", notes = "采购订单明细接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(Purchaseorder purchaseorder,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<Purchaseorder> queryWrapper = QueryGenerator.initQueryWrapper(purchaseorder, req.getParameterMap());
        Page<Purchaseorder> page = new Page<Purchaseorder>(pageNo, pageSize);
        IPage<Purchaseorder> pageList = iPurchaseorderService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    @AutoLog(value = "同步生成销售订单接口-同步至金蝶")
    @ApiOperation(value = "同步生成销售订单接口-同步至金蝶", notes = "同步生成销售订单接口-同步至金蝶")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronizationList() throws IOException, ParseException {
        boolean success = false;
        Map<String, String> synchronization = iPurchaseorderService.synchronization(null);
        if (synchronization.containsKey("success")) {
            if ("true".equals(synchronization.get("success"))) {
                success = true;
            }
        }
        return Result.OK(success);
    }

    @GetMapping("")
    public void test() {
        QueryWrapper<Purchaseorder> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("F_Id");
        queryWrapper.select("po_Item_Id");
//    Object SaleOrderId = l.get(i++).get(0);//销售订单id，可匹配过滤是否平台生成订单获取采购订单行项目号
        queryWrapper.eq("F_Id", "183867");
        //查询是否为集成平台生成的订单，并过滤
        Purchaseorder purchaseorders1 = iPurchaseorderService.getBaseMapper().selectOne(queryWrapper);
        System.out.println(purchaseorders1);
    }

}
