package org.jeecg.modules.iost.API.controller.pojo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.API.entity.pojo.Supplylist;
import org.jeecg.modules.iost.API.service.pojo.ISupplylistPojoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;

@Api(tags="存放国网供货单数据信息")
@RestController
@RequestMapping("/API/supplyListPojo")
@Slf4j
public class SupplyListPojoController {
    @Autowired
    private ISupplylistPojoService supplylistPojoService;

    /**
     * 分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "国网备品数据信息接口-分页列表查询")
    @ApiOperation(value = "国网备品数据信息接口-分页列表查询", notes = "国网备品数据信息接口-分页列表查询")
    @GetMapping(value = "list")
    public Result<?> queryPageList(Supplylist supplylist,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {

        QueryWrapper<Supplylist> queryWrapper = QueryGenerator.initQueryWrapper(supplylist, req.getParameterMap());
        Page<Supplylist> page = new Page<Supplylist>(pageNo, pageSize);
        IPage<Supplylist> pageList = supplylistPojoService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 同步今天金蝶云新增的销售出货单到国网
     * @return
     */
    @AutoLog(value = "国网供货单信息API-同步")
    @ApiOperation(value="国网供货单信息API-同步", notes="国网供货单信息API-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization() throws ParseException {
        Boolean synchronization = supplylistPojoService.synchronization(null);
        return Result.OK(synchronization);
    }
}
