package org.jeecg.modules.iost.API.controller.video;//package org.jeecg.modules.iost.API.controller.view;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


@RequestMapping("/asAlter")
@Slf4j
//@Scope("session")
@Api(tags = "请求金蝶日志")
@RestController
public class HlsAlterController {
    private Map<String, InputStream> urlPath = new HashMap<>();
    @Value("${server.port}")
    private int port;
    @Value("${server.servlet.context-path}")
    private String path;
    @Value("${server.localip}")
    private String ip;

    private String dockerip = "www.lingqingkeji.com";

    public HlsAlterController() throws UnknownHostException {
    }


    @GetMapping("/GetFile.m3u8")
    public void getFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        urlPath=new HashMap<>();
//        读取路径下面的文件
        String originUrlpath = "https://hls01open.ys7.com/openlive/6e0b2be040a943489ef0b9bb344b96b8.hd.m3u8";
        //文件流返回格式设为.m3u8
        response.setContentType("application/vnd.apple.mpegurl");
        //读取指定路径下面的文件
        String indexStr = getIndexFile(originUrlpath);//解析originUrlpath 返回为文本
        List urlList = analysisIndex(indexStr);//解析indexStr获取.ts文件地址
        String inIp="192.168.2.209";
        String localPath = "http://" + ip + ":" + port + path + "/";
        Map<String, InputStream> urlPathnew = new HashMap<>();
        for (int i = 0; i < urlList.size(); i++) {
            String url = urlList.get(i).toString();//
            InputStream fileInputStream = getFileInputStream(url);
            String tsUrl = UUID.randomUUID().toString() + ".ts";//文件后缀，key
            String localPathTs = localPath + "asAlter/GetTs/" + tsUrl;
            String resultA = indexStr.replaceAll(url, localPathTs);//文本中的“url”替换为“localPathTs”
            urlPathnew.put(tsUrl, fileInputStream);
            indexStr = resultA;
        }
        urlPath=urlPathnew;
        InputStream in = new ByteArrayInputStream(indexStr.getBytes());

        OutputStream outputStream = new BufferedOutputStream(response.getOutputStream());
        //创建存放文件内容的数组
        byte[] buff = new byte[1024];
        //所读取的内容使用n来接收
        int n;
        //当没有读取完时,继续读取,循环
        while ((n = in.read(buff)) != -1) {
            //将字节数组的数据全部写入到输出流中
            outputStream.write(buff, 0, n);
        }
        //强制将缓存区的数据进行输出
        outputStream.flush();
        //关流
        outputStream.close();
        in.close();
    }

    public String getIndexFile(String urlpath) throws Exception {
        URL url = new URL(urlpath);
        //下载资源
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));

        String content = "";
        String line;
        while ((line = in.readLine()) != null) {
            content += line + "\n";
        }
        in.close();
        return content;
    }

    /* 解析索引文件 */
    public List analysisIndex(String content) throws Exception {
        Pattern pattern = Pattern.compile(".*ts");
        Matcher ma = pattern.matcher(content);
        List<String> list = new ArrayList<String>();

        while (ma.find()) {
            list.add(ma.group());
        }

        return list;
    }

    /*读取网络文件*/
    @GetMapping("/GetTs/{path}")
    public void getFileInputStream(@PathVariable() String path, HttpServletResponse response) {
        InputStream in = urlPath.get(path);
        try {
            response.setContentType("application/x-linguist");
            OutputStream outputStream = new BufferedOutputStream(response.getOutputStream());
            //创建存放文件内容的数组
            byte[] buff = new byte[1024];
            //所读取的内容使用n来接收
            int n;
            //当没有读取完时,继续读取,循环
            while ((n = in.read(buff)) != -1) {
                //将字节数组的数据全部写入到输出流中
                outputStream.write(buff, 0, n);
            }
            //强制将缓存区的数据进行输出
            outputStream.flush();
            //关流
            outputStream.close();
            in.close();
        } catch (Exception e) {
            System.out.println("读取网络文件异常:" + path);
//            logger.error("读取网络文件异常:"+path);
        }finally {

            urlPath.remove(path);
        }

    }

    /*测试推流*/
    /*读取网络文件*/
    public InputStream getFileInputStream(String path) {
        URL url = null;
        try {
            url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            //设置超时间为3秒
            conn.setConnectTimeout(3*1000);
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            //得到输入流
            return conn.getInputStream();
        } catch (Exception e) {
            System.out.println("读取网络文件异常:"+path);
//            logger.error("读取网络文件异常:"+path);
        }
        return null;
    }

}
