package org.jeecg.modules.iost.API.controller.video;//package org.jeecg.modules.iost.API.controller.view;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.JeecgSystemApplication;
import org.jeecg.common.util.oConvertUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


@RequestMapping("/as")
@Slf4j
//@Scope("prototype")
@Api(tags = "请求金蝶日志")
@RestController
public class HlsController {
    private Map<String, String> urlPath = new HashMap<>();
    @Value("${server.port}")
    private int port;
    @Value("${server.servlet.context-path}")
    private String path;
    @Value("${server.localip}")
    private String ip;
    private String dockerip = "www.lingqingkeji.com";

    public HlsController() throws UnknownHostException {
    }


    @GetMapping("/GetFile.m3u8")
    public void getFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
//        urlPath=null;
//        读取路径下面的文件
        String originUrlpath = "https://hls01open.ys7.com/openlive/6e0b2be040a943489ef0b9bb344b96b8.hd.m3u8";
        //文件流返回格式设为.m3u8
        response.setContentType("application/vnd.apple.mpegurl");
        //读取指定路径下面的文件
        String indexStr = getIndexFile(originUrlpath);//解析originUrlpath 返回为文本
        List urlList = analysisIndex(indexStr);//解析indexStr获取.ts文件地址
        String localPath = "http://" + ip + ":" + port + path + "/";
        System.out.println(urlList);
        for (int i = 0; i < urlList.size(); i++) {
            String tsUrl = UUID.randomUUID().toString() + ".ts";//文件后缀，key
            String localPathTs = localPath + "as/GetTs/" + tsUrl;
            String url = urlList.get(i).toString();//
            String resultA = indexStr.replaceAll(url, localPathTs);//文本中的“url”替换为“localPathTs”
            urlPath.put(tsUrl, url);
            indexStr = resultA;
        }
        InputStream in = new ByteArrayInputStream(indexStr.getBytes());
        OutputStream outputStream = new BufferedOutputStream(response.getOutputStream());
        //创建存放文件内容的数组
        byte[] buff = new byte[1024];
        //所读取的内容使用n来接收
        int n;
        //当没有读取完时,继续读取,循环
        while ((n = in.read(buff)) != -1) {
            //将字节数组的数据全部写入到输出流中
            outputStream.write(buff, 0, n);
        }
        //强制将缓存区的数据进行输出
        outputStream.flush();
        //关流
        outputStream.close();
        in.close();
    }

    public String getIndexFile(String urlpath) throws Exception {
        URL url = new URL(urlpath);
        //下载资源
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));

        String content = "";
        String line;
        while ((line = in.readLine()) != null) {
            content += line + "\n";
        }
        in.close();
        return content;
    }

    /* 解析索引文件 */
    public List analysisIndex(String content) throws Exception {
        Pattern pattern = Pattern.compile(".*ts");
        Matcher ma = pattern.matcher(content);

        List<String> list = new ArrayList<String>();

        while (ma.find()) {
            list.add(ma.group());
        }

        return list;
    }

    /*读取网络文件*/
    @GetMapping("/GetTs/{path}")
    public void getFileInputStream(@PathVariable() String path, HttpServletResponse response) {
        System.out.println("GetTs" + path);
        String s = urlPath.get(path);
        System.out.println("path" + s);
        System.out.println(urlPath);
        URL url = null;
        try {
            url = new URL(s + "?Usr=c1cbc1d4e86d49a0981f54beea95280a");
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            //设置超时间为3秒
            conn.setConnectTimeout(3 * 1000);
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            //得到输入流
            InputStream in = conn.getInputStream();
            response.setContentType("application/x-linguist");
            OutputStream outputStream = new BufferedOutputStream(response.getOutputStream());
            //创建存放文件内容的数组
            byte[] buff = new byte[1024];
            //所读取的内容使用n来接收
            int n;
            //当没有读取完时,继续读取,循环
            while ((n = in.read(buff)) != -1) {
                //将字节数组的数据全部写入到输出流中
                outputStream.write(buff, 0, n);
            }
            //强制将缓存区的数据进行输出
            outputStream.flush();
            //关流
            outputStream.close();
            in.close();
        } catch (Exception e) {
            System.out.println("读取网络文件异常:" + path);
//            logger.error("读取网络文件异常:"+path);
        } finally {
            urlPath.remove(path);
        }

    }

    /*测试推流*/
    @GetMapping("/setStr.ts")
    public void setStr(HttpServletRequest request, HttpServletResponse response) throws Exception {
//        读取路径下面的文件
        File file = new File("D:\\test\\");
        File picFile = null;
        for (File f : file.listFiles()) {
            if (f.getName().contains("DEMO.ts")) {
                //根据路径获取文件
                picFile = new File(f.getPath());
                System.out.println("picFile" + picFile);
                //获取文件后缀名格式
                String ext = picFile.getName().substring(picFile.getName().indexOf("."));
                System.out.println("ext" + ext);
                //判断图片格式,设置相应的输出文件格式
                if (ext.equals("jpg")) {
                    response.setContentType("image/jpeg");
                } else if (ext.equals("JPG")) {
                    response.setContentType("image/jpeg");
                } else if (ext.equals("png")) {
                    response.setContentType("image/png");
                } else if (ext.equals("PNG")) {
                    response.setContentType("image/png");
                } else if (ext.equals("txt")) {
                    response.setContentType("text/plain");
                } else if (ext.equals("ts")) {
                    response.setContentType("application/x-linguist");
                }
            }
        }

        InputStream in = new FileInputStream(picFile);
        System.out.println("in" + in);
        OutputStream outputStream = new BufferedOutputStream(response.getOutputStream());
        //创建存放文件内容的数组
        byte[] buff = new byte[1024];
        //所读取的内容使用n来接收
        int n;
        //当没有读取完时,继续读取,循环
        while ((n = in.read(buff)) != -1) {
            //将字节数组的数据全部写入到输出流中
            System.out.println();
            System.out.println("文件内容的数组" + buff);
            System.out.println("读取的内容" + n);
            outputStream.write(buff, 0, n);
        }
        //强制将缓存区的数据进行输出
        outputStream.flush();
        System.out.println(outputStream);
        //关流
        outputStream.close();
        in.close();
    }

}
