package org.jeecg.modules.iost.API.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecg.common.constant.CommonConstant;

import java.io.Serializable;

/**
 * 接口返回数据格式
 */
@Data
@ApiModel(value = "接口返回对象", description = "接口返回对象")
public class Request<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 成功标志
     */
    @ApiModelProperty(value = "成功标志")
    private boolean successful = true;

    /**
     * ？
     */
    @ApiModelProperty(value = "成功标志")
    private String type ;

    /**
     * ？
     */
    @ApiModelProperty(value = "成功标志")
    private String resultHint ;

/*
    */
/**
     * 返回处理消息h
     *//*

    @ApiModelProperty(value = "返回处理消息")
    private String message = "操作成功！";
*/

    /**
     * 返回代码
     */
    //@ApiModelProperty(value = "返回代码")
   // private Integer code = 0;

    /**
     * 返回数据对象 data
     */
    @ApiModelProperty(value = "返回数据对象")
    private T resultValue;

    /**
     * 时间戳
     */
   // @ApiModelProperty(value = "时间戳")
   // private long timestamp = System.currentTimeMillis();
    /**
     * 来源系统标识，1：网关；2：品类管理中心
     */

    public Request() {

    }

    public Request<T> successful(String message) {
        //this.message = message;
        //this.code = CommonConstant.SC_OK_200;
        this.successful = true;
        return this;
    }

    @Deprecated
    public static Request<Object> ok() {
        Request<Object> r = new Request<Object>();
        r.setSuccessful(true);
        //r.setCode(CommonConstant.SC_OK_200);
       //r.setMessage("成功");
        r.setType("");
        r.setResultHint("");
        return r;
    }

    @Deprecated
    public static Request<Object> ok(String msg) {
        Request<Object> r = new Request<Object>();
        r.setSuccessful(true);
        //r.setCode(CommonConstant.SC_OK_200);
        //r.setMessage(msg);
        r.setType("");
        r.setResultHint("");
        return r;
    }

    @Deprecated
    public static Request<Object> ok(Object data) {
        Request<Object> r = new Request<Object>();
        r.setSuccessful(true);
        //r.setCode(CommonConstant.SC_OK_200);
        //r.setResult(data);
        r.setType("");
        r.setResultHint("");
        r.setResultValue(data);
        return r;
    }

    public static <T> Request<T> OK() {
        Request<T> r = new Request<T>();
        r.setSuccessful(true);
        //r.setCode(CommonConstant.SC_OK_200);
       // r.setMessage("成功");
        r.setType("");
        r.setResultHint("");
        return r;
    }

    public static <T> Request<T> OK(T data) {
        Request<T> r = new Request<T>();
        r.setSuccessful(true);
        //r.setCode(CommonConstant.SC_OK_200);
        //r.setResult(data);
        r.setType("");
        r.setResultHint("");
        r.setResultValue(data);
        return r;
    }

    public static <T> Request<T> OK(String msg, T data) {
        Request<T> r = new Request<T>();
        r.setSuccessful(true);
        //r.setCode(CommonConstant.SC_OK_200);
       // r.setMessage(msg);
        r.setType("");
        r.setResultHint("");
        r.setResultValue(data);
        return r;
    }

    public static Request<Object> error(String msg) {
        return error(CommonConstant.SC_INTERNAL_SERVER_ERROR_500, msg);
    }

    public static Request<Object> error10001(String msg) {
        return error(10001, msg);
    }

    public static Request<Object> error(int code, String msg) {
        Request<Object> r = new Request<Object>();
        //r.setCode(code);
        // r.setMessage(msg);
        r.setType("");
        r.setResultHint("");
        r.setSuccessful(false);
        return r;
    }

    public Request<T> error500(String message) {
        //this.message = message;
        //this.code = CommonConstant.SC_INTERNAL_SERVER_ERROR_500;
        this.successful = false;
        return this;
    }

    /**
     * 无权限访问返回结果
     */
    public Request noauth(String msg) {
        return error(CommonConstant.SC_JEECG_NO_AUTHZ, msg);
    }

    @JsonIgnore
    private String onlTable;
}
