package org.jeecg.modules.iost.API.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 国网日志
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("grid_error")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="grid_error对象", description="国网日志请求")
public class GridError implements Serializable {
    private static final long serialVersionUID = 1L;
    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**报错代码*/
    private Integer status;
    /**返回信息*/
    private String message;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createtime;
    //传入国网数据
    private String requestjson;
    //国网响应数据
    private String responsejson;
    /**数据同步:失败:0,成功:1*/
    private Integer synchronization;
    /**
     * 是否已成功:失败:0,成功:1
     */
    private Integer successagain;
    /**业务编号**/
    private Integer businessNo;
    // 传入的业务
    private String businessName;
}
