package org.jeecg.modules.iost.API.entity.pojo;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 国网供应商重点原材料库存API
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("materialinventory")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="materialinventory对象", description="国网供应商重点原材料库存API")
public class Materialinventory implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**实体主键*/
    @Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private String fid;
    /**单据编号*/
    @Excel(name = "单据编号", width = 15)
    @ApiModelProperty(value = "单据编号")
    private String fbillno;
    /**采购方总部编码*/
    @Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
    /**供应商编码*/
    @Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
    /**供应商名称*/
    @Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
    /**原材料名称*/
    @Excel(name = "原材料名称", width = 15)
    @ApiModelProperty(value = "原材料名称")
    private String matname;
    /**原材料编码*/
    @Excel(name = "原材料编码", width = 15)
    @ApiModelProperty(value = "原材料编码")
    private String matcode;
    /**原材料库存数量*/
    @Excel(name = "原材料库存数量", width = 15)
    @ApiModelProperty(value = "原材料库存数量")
    private String matnum;
    /**原材料单位*/
    @Excel(name = "原材料单位", width = 15)
    @ApiModelProperty(value = "原材料单位")
    private String matunit;
    /**原材料描述*/
    @Excel(name = "原材料描述", width = 15)
    @ApiModelProperty(value = "原材料描述")
    private String matdescription;
    /**原材料产地*/
    @Excel(name = "原材料产地", width = 15)
    @ApiModelProperty(value = "原材料产地")
    private String matprodaddr;
    /**数据来源:0：供应商， 1：网关， 2：代理*/
    @Excel(name = "数据来源:0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源:0：供应商， 1：网关， 2：代理")
    private String datasource;
    /**来源数据创建时间*/
    @Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
    /**备注*/
    @Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
    /**数据拥有方:取值：供应商编码*/
    @Excel(name = "数据拥有方:取值：供应商编码", width = 15)
    @ApiModelProperty(value = "数据拥有方:取值：供应商编码")
    private String ownerid;
    /**数据可见方:取值：采购方编码*/
    @Excel(name = "数据可见方:取值：采购方编码", width = 15)
    @ApiModelProperty(value = "数据可见方:取值：采购方编码")
    private String openid;
}
