package org.jeecg.modules.iost.API.entity.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 实物ID信息明细
 * @Author: jeecg-boot
 * @Date: 2021-07-09
 * @Version: V1.0
 */
@Data
@TableName("supplier_end_physicalid")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "physicalid对象", description = "实物ID信息明细")
public class Physicalid implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    @Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
    /**
     * 供应商编码
     */
    @Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
    /**
     * 供应商名称
     */
    @Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
    /**
     * 实物ID
     */
    @Excel(name = "实物ID", width = 15)
    @ApiModelProperty(value = "实物ID")
    private String entitycode;
    /**
     * 采购订单行项目id
     */
    @Excel(name = "采购订单行项目id", width = 15)
    @ApiModelProperty(value = "采购订单行项目id")
    private String poitemid;
    /**
     * 实物生产状态:0：未生产 1：生产中 2：生产完成
     */
    @Excel(name = "实物生产状态:0：未生产 1：生产中 2：生产完成", width = 15)
    @ApiModelProperty(value = "实物生产状态:0：未生产 1：生产中 2：生产完成")
    private String entitystatus;
    /**
     * 数据来源:0：供应商， 1：网关， 2：代理
     */
    @Excel(name = "数据来源:0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源:0：供应商， 1：网关， 2：代理")
    private String datasource;
    /**
     * 来源数据创建时间
     */
    @Excel(name = "来源数据创建时间", width = 15, format = "yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "来源数据创建时间")
    private Date datasourcecreatetime;
    /**
     * 备注
     */
    @Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
    /**
     * 数据拥有方:取值：供应商编码
     */
    @Excel(name = "数据拥有方:取值：供应商编码", width = 15)
    @ApiModelProperty(value = "数据拥有方:取值：供应商编码")
    private String ownerid;
    /**
     * 数据可见方:取值：采购方编码
     */
    @Excel(name = "数据可见方:取值：采购方编码", width = 15)
    @ApiModelProperty(value = "数据可见方:取值：采购方编码")
    private String openid;
    /**
     * 审核日期记录
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss.SSS")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss.SSS")
    @ApiModelProperty(value = "审核日期记录")
    private Date fapprovedate;
    //*实物ID编码*//
    private String fbillno;
    /**单据编号**/
    private String fid;
}
