package org.jeecg.modules.iost.API.entity.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

@Data
@TableName("productionscheduling")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="productionscheduling对象", description="排产计划API")
public class Productionscheduling {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**采购方总部编码*/
    @Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
    /**供应商编码*/
    @Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
    /**供应商名称*/
    @Excel(name = "供应商名称", width = 15)
    @ApiModelProperty(value = "供应商名称")
    private String suppliername;
    /**采购订单行项目 id*/
    @Excel(name = "采购订单行项目 id", width = 15)
    @ApiModelProperty(value = "采购订单行项目 id")
    private Integer poitemid;
    /**排产计划编码*/
    @Excel(name = "排产计划编码", width = 15)
    @ApiModelProperty(value = "排产计划编码")
    private String schedulecode;
    /**省公司单位编码*/
    @Excel(name = "省公司单位编码", width = 15)
    @ApiModelProperty(value = "省公司单位编码")
    private String provcocode;
    /**省公司单位名称*/
    @Excel(name = "省公司单位名称", width = 15)
    @ApiModelProperty(value = "省公司单位名称")
    private String provconame;
    /**计划工期（天数）*/
    @Excel(name = "计划工期（天数）", width = 15)
    @ApiModelProperty(value = "计划工期（天数）")
        private String planperiod;
    /**实际工期*/
    @Excel(name = "实际工期", width = 15)
    @ApiModelProperty(value = "实际工期")
    private String actualperiod;
    /**进度*/
    @Excel(name = "进度", width = 15)
    @ApiModelProperty(value = "进度")
    private String schedule;
    /**交付日期（最后日期，底线）*/
    @Excel(name = "交付日期（最后日期，底线）", width = 15)
    @ApiModelProperty(value = "交付日期（最后日期，底线）")
    private String duedate;
    /**计划开始日期*/
    @Excel(name = "计划开始日期", width = 15)
    @ApiModelProperty(value = "计划开始日期")
    private String planstartdate;
    /**计划完成日期*/
    @Excel(name = "计划完成日期", width = 15)
    @ApiModelProperty(value = "计划完成日期")
    private String planfinishdate;
    /**实际开始日期*/
    @Excel(name = "实际开始日期", width = 15)
    @ApiModelProperty(value = "实际开始日期")
    private String actualstartdate;
    /**实际完成日期*/
    @Excel(name = "实际完成日期", width = 15)
    @ApiModelProperty(value = "实际完成日期")
    private String actualfinishdate;
    /**品类编码*/
    @Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private String categorycode;
    /**种类编码*/
    @Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private String subclasscode;
    /**备注*/
    @Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
    /**数据来源*/
    @Excel(name = "数据来源", width = 15)
    @ApiModelProperty(value = "数据来源")
    private String datasource;
    /**来源数据创建时间*/
    @Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
    /**数据拥有方*/
    @Excel(name = "数据拥有方", width = 15)
    @ApiModelProperty(value = "数据拥有方")
    private String ownerid;
    /**数据可见方*/
    @Excel(name = "数据可见方", width = 15)
    @ApiModelProperty(value = "数据可见方")
    private String openid;
    /**实体主键*/
    @Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private String fid;
}
