package org.jeecg.modules.iost.API.entity.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 采购订单明细
 * @Author: jeecg-boot
 * @Date: 2021-07-09
 * @Version: V1.0
 */
@Data
@TableName("supplier_end_purchaseorder")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "purchaseorder对象", description = "采购订单明细")
public class Purchaseorder implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**
     * 采购订单编码
     */
    private String poNo;
    /**
     * 采购订单行项目号
     */
    private String poItemNo;
    /**
     * 采购订单行项目id
     */
    private String poItemId;
    /**
     * 合同编号
     */
    private String conCode;
    /**
     * 合同名称
     */
    private String conName;
    /**
     * 采购方公司名称
     */
    private String buyerName;
    /**
     * 采购方公司编码
     */
    private String buyerCode;
    /**
     * 采购方物料编码
     */
    private String materialCode;
    /**
     * 采购方物料描述
     */
    private String materialDesc;
    /**
     * 采购数量
     */
    private String amount;
    /**
     * 合同编号（国网经法）
     */
    private String sellerConCode;
    /**
     * 技术规范流水号
     */
    private String serialNumber;
    /**
     * 合同签订日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date sellerSignTime;
    /**
     * 合同类型:1标准合同；2协议库存；3采购供货单
     */
    private int conType;
    /**
     * 项目编号
     */
    private String prjCode;
    /**
     * 工程项目名称
     */
    private String prjName;
    /**
     * 物资编码
     */
    private String matCode;
    /**
     * 采购技术固化ID
     */
    private String fixedTechId;

//   合同包号
    private String pkgNo;
   /**招标批次号
     */
    private String bidBatCode;
    /**
     * 固化ID描述
     */
    private String extDes;
    /**
     * 物资大类编码
     */
    private String matMaxCode;
    /**
     * 物资中类编码
     */
    private String matMedCode;
    /**
     * 物资小类编码
     */
    private String matMinCode;
    /**
     * 物资大类名称
     */
    private String matMaxName;
    /**
     * 物资中类名称
     */
    private String matMedName;
    /**
     * 物资小类名称
     */
    private String matMinName;
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    /**
     * 销售订单内码
     */
    private String FId;
    /**
     * 销售订单编码
     */
    private String FNumber;
}
