package org.jeecg.modules.iost.API.entity.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

@Data
@TableName("salesorder")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "salesorder对象", description = "销售订单API")
public class Salesorder {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**
     * 采购方总部编码
     */
    @Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
    /**
     * 销售订单号
     */
    @Excel(name = "销售订单号", width = 15)
    @ApiModelProperty(value = "销售订单号")
    private String sono;
    /**
     * 供应商编码
     */
    @Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
    /**
     * 采购方公司编码
     */
    @Excel(name = "采购方公司编码", width = 15)
    @ApiModelProperty(value = "采购方公司编码")
    private String buyercode;
    /**
     * 采购方公司名称
     */
    @Excel(name = "采购方公司名称", width = 15)
    @ApiModelProperty(value = "采购方公司名称")
    private String buyername;
    /**
     * 采购方公司省份
     */
    @Excel(name = "采购方公司省份", width = 15)
    @ApiModelProperty(value = "采购方公司省份")
    private String buyerprovince;
    /**
     * 品类编码
     */
    @Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private String categorycode;
    /**
     * 种类编码
     */
    @Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private String subclasscode;
    /**
     * 销售订单状态
     */
    @Excel(name = "销售订单状态", width = 15)
    @ApiModelProperty(value = "销售订单状态")
    private String sostatus;
    /**
     * 销售订单行项目号
     */
    @Excel(name = "销售订单行项目号", width = 15)
    @ApiModelProperty(value = "销售订单行项目号")
    private String soitemno;
    /**
     * 采购订单行项目ID
     */
    @Excel(name = "采购订单行项目ID", width = 15)
    @ApiModelProperty(value = "采购订单行项目ID")
    private String poitemid;
    /**
     * 物资编码
     */
    @Excel(name = "物资编码", width = 15)
    @ApiModelProperty(value = "物资编码")
    private String productcode;
    /**
     * 物资名称
     */
    @Excel(name = "物资名称", width = 15)
    @ApiModelProperty(value = "物资名称")
    private String productname;
    /**
     * 物资单位
     */
    @Excel(name = "物资单位", width = 15)
    @ApiModelProperty(value = "物资单位")
    private String productunit;
    /**
     * 物资数量
     */
    @Excel(name = "物资数量", width = 15)
    @ApiModelProperty(value = "物资数量")
    private String productamount;
    /**
     * 数据拥有方
     */
    @Excel(name = "数据拥有方", width = 15)
    @ApiModelProperty(value = "数据拥有方")
    private String ownerid;
    /**
     * 数据可见方
     */
    @Excel(name = "数据可见方", width = 15)
    @ApiModelProperty(value = "数据可见方")
    private String openid;
    /**
     * 数据来源 0：供应商， 1：网关， 2：代理
     */
    @Excel(name = "数据来源 0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源 0：供应商， 1：网关， 2：代理")
    private String datasource;
    /**
     * 来源数据创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "来源数据创建时间", width = 15)
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
    /**
     * 实体主键
     */
    @Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private String fid;

    /**
     * 销售订单编码
     */
    @Excel(name = "销售订单编码", width = 15)
    @ApiModelProperty(value = "销售订单编码")
    private String fbillno;
}
