package org.jeecg.modules.iost.API.entity.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 供货单信息
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Data
@TableName("supplylist")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="supplylist_api对象", description="供货单信息")
public class Supplylist implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**实体主键*/
    @Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private String fid;
    /**供货单编码*/
    @Excel(name = "供货单编码", width = 15)
    @ApiModelProperty(value = "供货单编码")
    private String fbillno;
    /**采购方总部编码*/
    @Excel(name = "采购方总部编码", width = 15)
    @ApiModelProperty(value = "采购方总部编码")
    private String purchaserhqcode;
    /**供应商编码*/
    @Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private String suppliercode;
    /**合同类型：1标准合同；2协议库存；3采购供货单*/
    @Excel(name = "合同类型：1标准合同；2协议库存；3采购供货单", width = 15)
    @ApiModelProperty(value = "合同类型：1标准合同；2协议库存；3采购供货单")
    private String contype;
    /**采购供货单编号*/
    @Excel(name = "采购供货单编号", width = 15)
    @ApiModelProperty(value = "采购供货单编号")
    private String supplyno;
    /**合同编号*/
    @Excel(name = "合同编号", width = 15)
    @ApiModelProperty(value = "合同编号")
    private String concode;
    /**合同签订日期*/
    @Excel(name = "合同签订日期", width = 15, format = "yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "合同签订日期")
    private Date sellersigntime;
    /**工程项目名称*/
    @Excel(name = "工程项目名称", width = 15)
    @ApiModelProperty(value = "工程项目名称")
    private String prjname;
    /**合同名称*/
    @Excel(name = "合同名称", width = 15)
    @ApiModelProperty(value = "合同名称")
    private String conname;
    /**合同编号（国网经法)*/
    @Excel(name = "合同编号（国网经法)", width = 15)
    @ApiModelProperty(value = "合同编号（国网经法)")
    private String sellerconcode;
    /**物资大类编号*/
    @Excel(name = "物资大类编号", width = 15)
    @ApiModelProperty(value = "物资大类编号")
    private String matmaxcode;
    /**物资中类编号*/
    @Excel(name = "物资中类编号", width = 15)
    @ApiModelProperty(value = "物资中类编号")
    private String matmedcode;
    /**物资小类编号*/
    @Excel(name = "物资小类编号", width = 15)
    @ApiModelProperty(value = "物资小类编号")
    private String matmincode;
    /**物资大类名称*/
    @Excel(name = "物资大类名称", width = 15)
    @ApiModelProperty(value = "物资大类名称")
    private String matmaxname;
    /**物资中类名称*/
    @Excel(name = "物资中类名称", width = 15)
    @ApiModelProperty(value = "物资中类名称")
    private String matmedname;
    /**物资小类名称*/
    @Excel(name = "物资小类名称", width = 15)
    @ApiModelProperty(value = "物资小类名称")
    private String matminname;
    /**货物名称*/
    @Excel(name = "货物名称", width = 15)
    @ApiModelProperty(value = "货物名称")
    private String cargoname;
    /**品类编码*/
    @Excel(name = "品类编码", width = 15)
    @ApiModelProperty(value = "品类编码")
    private String categorycode;
    /**种类编码*/
    @Excel(name = "种类编码", width = 15)
    @ApiModelProperty(value = "种类编码")
    private String subclasscode;
    /**采购方公司名称*/
    @Excel(name = "采购方公司名称", width = 15)
    @ApiModelProperty(value = "采购方公司名称")
    private String purchasename;
    /**采购方公司编码*/
    @Excel(name = "采购方公司编码", width = 15)
    @ApiModelProperty(value = "采购方公司编码")
    private String purchasecode;
    /**供货单项目号*/
    @Excel(name = "供货单项目号", width = 15)
    @ApiModelProperty(value = "供货单项目号")
    private String poitemno;
    /**供货单行项目收货方公司名称*/
    @Excel(name = "供货单行项目收货方公司名称", width = 15)
    @ApiModelProperty(value = "供货单行项目收货方公司名称")
    private String receivedname;
    /**供货单行项目供应商侧物料编码*/
    @Excel(name = "供货单行项目供应商侧物料编码", width = 15)
    @ApiModelProperty(value = "供货单行项目供应商侧物料编码")
    private String materialcode;
    /**供货单行项目物料描述*/
    @Excel(name = "供货单行项目物料描述", width = 15)
    @ApiModelProperty(value = "供货单行项目物料描述")
    private String materialdesc;
    /**供货单行项目国网侧物料编码*/
    @Excel(name = "供货单行项目国网侧物料编码", width = 15)
    @ApiModelProperty(value = "供货单行项目国网侧物料编码")
    private String eipmaterialcode;
    /**供货单行项目国网侧物料描述*/
    @Excel(name = "供货单行项目国网侧物料描述", width = 15)
    @ApiModelProperty(value = "供货单行项目国网侧物料描述")
    private String eipmaterialdesc;
    /**供货单行项目采购数量*/
    @Excel(name = "供货单行项目采购数量", width = 15)
    @ApiModelProperty(value = "供货单行项目采购数量")
    private String amount;
    /**供货单行项目计量单位*/
    @Excel(name = "供货单行项目计量单位", width = 15)
    @ApiModelProperty(value = "供货单行项目计量单位")
    private String measunit;
    /**数据来源：0：供应商， 1：网关， 2：代理*/
    @Excel(name = "数据来源：0：供应商， 1：网关， 2：代理", width = 15)
    @ApiModelProperty(value = "数据来源：0：供应商， 1：网关， 2：代理")
    private String datasource;
    /**来源数据创建时间*/
    @Excel(name = "来源数据创建时间", width = 15, format = "yyyy-MM-dd")
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "来源数据创建时间")
    private String datasourcecreatetime;
    /**备注*/
    @Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
    /**数据拥有方：取值：供应商编码*/
    @Excel(name = "数据拥有方：取值：供应商编码", width = 15)
    @ApiModelProperty(value = "数据拥有方：取值：供应商编码")
    private String ownerid;
    /**数据可见方：取值：采购方编码*/
    @Excel(name = "数据可见方：取值：采购方编码", width = 15)
    @ApiModelProperty(value = "数据可见方：取值：采购方编码")
    private String openid;
}
