package org.jeecg.modules.iost.API.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.dto.EIP;
import org.jeecg.modules.iost.API.entity.GridErrorReturnProcess;
import org.jeecg.modules.iost.API.mapper.GridErrorReturnProcessMapper;
import org.jeecg.modules.iost.API.service.IGridErrorReturnProcessService;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
@Scope("prototype")
public class GridErrorReturnProcessServiceImpl extends ServiceImpl<GridErrorReturnProcessMapper, GridErrorReturnProcess> implements IGridErrorReturnProcessService {


    public Map<Boolean, String> setGridError(JSONObject jsonObject, String requestJson, Integer BusinessNo) throws ParseException {
        Boolean complent = true;
        Map<Boolean, String> save = new HashMap<>();
        GridErrorReturnProcess gridError = addGridError(jsonObject, requestJson, BusinessNo);
        complent = this.save(gridError);
        save.put(complent, gridError.getId());
        return save;
    }

    public GridErrorReturnProcess addGridError(JSONObject jsonObject, String requestJson, Integer BusinessNo) throws ParseException {

        //转换为请求国网日志
        GridErrorReturnProcess gridError = new GridErrorReturnProcess();
        if (jsonObject.get("successful") != null) {
            //请求国网的返回信息
            JSONObject resultValue = JSONObject.fromObject(jsonObject.get("resultValue"));
            Object data = resultValue.get("data");//获取返回数据的 data对象
            gridError.setMessage(resultValue.get("message").toString());
            gridError.setRequestjson(requestJson);
            gridError.setResponsejson(data.toString());
            gridError.setStatus(Integer.parseInt(resultValue.get("status").toString()));
            gridError.setCreatetime(new Date());
            gridError.setSynchronization(data == null ? 0 : 1);
            gridError.setBusinessNo(BusinessNo);
            gridError.setBusinessName(EIP.entity.get(BusinessNo));
        } else {
            //请求国网的返回信息-错误
            gridError.setMessage(jsonObject.get("message").toString());
            gridError.setRequestjson(requestJson);
            gridError.setResponsejson(jsonObject.get("result").toString());
            gridError.setStatus((int) jsonObject.get("code"));
            gridError.setCreatetime(new Date());
            gridError.setSynchronization(0);
            gridError.setBusinessNo(BusinessNo);
            gridError.setBusinessName(EIP.entity.get(BusinessNo));
        }

        return gridError;
    }
}
