package org.jeecg.modules.iost.API.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.dto.EIP;
import org.jeecg.modules.iost.API.entity.GridError;
import org.jeecg.modules.iost.API.mapper.GridErrorMapper;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;

@Service
@Scope("prototype")
public class GridErrorServiceImpl extends ServiceImpl<GridErrorMapper, GridError> implements IGridErrorService {

    public Boolean setGridError(JSONObject jsonObject, Map<String, String> json, Integer BusinessNo) throws ParseException {
        boolean save = addGridError(jsonObject, json, BusinessNo);
        return save;
    }

    public Boolean addGridError(JSONObject jsonObject, Map<String, String> json,Integer BusinessNo) throws ParseException {
        Boolean complent=false;
        //转换为请求国网日志
        GridError gridError = new GridError();
        if (jsonObject.get("successful") != null) {
            //请求国网的返回信息
            JSONObject resultValue = JSONObject.fromObject(jsonObject.get("resultValue"));
            Object data = resultValue.get("data");//获取返回数据的 data对象
            gridError.setMessage(resultValue.get("message").toString());
            gridError.setRequestjson(JsonUtil.Mapjson(json));
            gridError.setResponsejson(data.toString());
            gridError.setStatus(Integer.parseInt(resultValue.get("status").toString()));
            gridError.setCreatetime(new Date());
            gridError.setSynchronization(data == null ? 0 : 1);
            gridError.setBusinessNo(BusinessNo);
            gridError.setBusinessName(EIP.entity.get(BusinessNo));
            complent=true;
        } else {
            //请求国网的返回信息-错误
            gridError.setMessage(jsonObject.get("message").toString());
            gridError.setRequestjson(JsonUtil.Mapjson(json));
            gridError.setResponsejson(jsonObject.get("result").toString());
            gridError.setStatus((int) jsonObject.get("code"));
            gridError.setCreatetime(new Date());
            gridError.setSynchronization(0);
            gridError.setBusinessNo(BusinessNo);
            gridError.setBusinessName(EIP.entity.get(BusinessNo));
        }
        if (!this.save(gridError)) {
            complent=false;
        }
        return complent;
    }
}
