package org.jeecg.modules.iost.API.service.pojo.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.MaterialinventoryApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournal;
import org.jeecg.modules.iost.API.entity.pojo.Materialinventory;
import org.jeecg.modules.iost.API.mapper.pojo.MaterialinventoryPojoMapeer;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.IKingdeeJournalService;
import org.jeecg.modules.iost.API.service.pojo.IMaterialinventoryPojoService;
import org.jeecg.modules.iost.API.webapi.MaterialWebapi;
import org.jeecg.modules.iost.API.webapi.MaterialinventoryWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 国网供应商重点原材料库存API
 * @Author: jeecg-boot
 * @Date:   2021-07-14
 * @Version: V1.0
 */
@Slf4j
@Service
public class MaterialinventoryPojoServiceImpl extends ServiceImpl<MaterialinventoryPojoMapeer, Materialinventory> implements IMaterialinventoryPojoService {
    private final static String name = "重点材料";
    private final static Integer BusinessNo = 6;
    @Autowired
    MaterialinventoryApi materialinventoryApi;
    @Autowired
    MaterialinventoryWebapi materialinventoryWebapi;
    @Autowired
    MaterialWebapi materialWebapi;
    @Autowired
    IKingdeeJournalService kingdeeJournalService;
    @Autowired
    IGridErrorService gridErrorService;
    /**
     * 同步将金蝶云采购入库单中的重点材料信息到国网上
     * @param object
     * @return
     */
    @Override
    public Boolean synchronization(Object object) throws ParseException {
        List<Materialinventory> pojolist=new ArrayList<>();
        //查询今天的入库单数据
        Boolean success = true;
        Map<String, List<List<Object>>> synchronization = null;
        //拆解select-获取金蝶云星空的响应信息数据
        List<Map<String, String>> list = null;
        if (object == null) {
            synchronization = materialinventoryWebapi.synchronization(null, null);
        } else {
            synchronization = materialinventoryWebapi.synchronization((String) object);
        }
        //保存金蝶云操作的日志记录
        list = KingdeeLog(synchronization);
        if (list == null || list.size() < 1) return false;
//        List<Map<String, String>> list =  materialinventoryWebapi.select(null,null  );
//        //设置金蝶日志
//        KingdeeLog(list);
        //遍历集合拿到所有的MAP
        for(Map<String,String> data:list){
            //设置同步代码的同步信息
            Materialinventory pojo=new Materialinventory();
            //拿到每个物料编码
            String fmaterialid = data.get("matcode");
            //通过物料编码来确认是否是重点原材料
            List<Map<String, String>> select = materialWebapi.select(new HashMap<String,String>(){{
                put("FNumber",fmaterialid);
                put("F_LQKJ_IsImportent","1");
            }}, null);
            //如果是重点原材料就添加到国网
            if (!select.isEmpty()){
                //将传入信息存放到实体类中
                pojo.setFid(data.get("fid"));
                pojo.setFbillno(data.get("fbillno"));
                pojo.setMatcode(data.get("matcode"));
                pojo.setMatname(data.get("matname"));
                pojo.setMatnum(data.get("matnum"));
                pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
                pojo.setSuppliercode(data.get("suppliercode"));
                pojo.setSuppliername(data.get("suppliername"));
                pojo.setDatasource("0");
                pojo.setPurchaserhqcode(data.get("purchaserhqcode"));
                pojo.setRemark(data.get("remark"));
                pojo.setOpenid(data.get("purchaserhqcode"));
                pojo.setOwnerid(data.get("suppliercode"));
                pojo.setMatunit(data.get("matunit"));
                pojolist.add(pojo);
                //添加到国网
                String rs = materialinventoryApi.add(data);
                //将返回信息封装成JSON
                JSONObject jsonObject = JSONObject.fromObject(rs);
                gridErrorService.setGridError(jsonObject,data,BusinessNo);
//                if(jsonObject.get("success")==null){
//                    //拿到返回信息
//                    materialinventoryerror.setMessage(jsonObject.get("message").toString());
//                    //拿到实体数据
//                    materialinventoryerror.setJson(JsonUtil.Mapjson(data));
//                    //设置报错代码
//                    materialinventoryerror.setStatus((int)jsonObject.get("code"));
//                    materialinventoryerror.setCreatetime(new Date());
//                    //将同步信息设置为1
//                    materialinventoryerror.setSynchronization(1);
//                    lists.add(materialinventoryerror);
//                }else{
//                    //获取错误日志
//                    materialinventoryerror.setMessage(jsonObject.get("message").toString());
//                    materialinventoryerror.setJson(jsonObject.get("result").toString());
//                    materialinventoryerror.setStatus((int) jsonObject.get("code"));
//                    materialinventoryerror.setCreatetime(new Date());
//                    //同步字段设置为0
//                    materialinventoryerror.setSynchronization(0);
//                    lists.add(materialinventoryerror);
//                }

            }
        }
        //将要添加到国网的信息存放到数据库
        this.saveBatch(pojolist);
//        if (this.saveBatch(lists)){
//
//        }
        return success;
    }
    public Boolean grid(Map<String, String> data) throws ParseException {
        Boolean aBoolean=false;
        Materialinventory pojo=new Materialinventory();
        //拿到每个物料编码
        String fmaterialid = data.get("matcode");
        //通过物料编码来确认是否是重点原材料
        List<Map<String, String>> select = materialWebapi.select(new HashMap<String,String>(){{
            put("FNumber",fmaterialid);
            put("F_LQKJ_IsImportent","1");
        }}, null);
        //如果是重点原材料就添加到国网
        if (!select.isEmpty()) {
            //将传入信息存放到实体类中
            pojo.setFid(data.get("fid"));
            pojo.setFbillno(data.get("fbillno"));
            pojo.setMatcode(data.get("matcode"));
            pojo.setMatname(data.get("matname"));
            pojo.setMatnum(data.get("matnum"));
            pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
            pojo.setSuppliercode(data.get("suppliercode"));
            pojo.setSuppliername(data.get("suppliername"));
            pojo.setDatasource("0");
            pojo.setPurchaserhqcode(data.get("purchaserhqcode"));
            pojo.setRemark(data.get("remark"));
            pojo.setOpenid(data.get("purchaserhqcode"));
            pojo.setOwnerid(data.get("suppliercode"));
            //添加到国网
            String rs = materialinventoryApi.add(data);
            //将返回信息封装成JSON
            JSONObject jsonObject = JSONObject.fromObject(rs);
            Boolean aBoolean1 =  gridErrorService.setGridError(jsonObject, data, BusinessNo);
            boolean save = this.save(pojo);
            aBoolean=aBoolean1==save;
        }
        return aBoolean;
    }
    //设置金蝶的请求日志
    public List<Map<String, String>> KingdeeLog(Map<String, List<List<Object>>> synchronization) throws ParseException {
        List<List<Object>> selectInList = null;
        List<Map<String, String>> list = null;
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                selectInList = synchronization.get(key);
                WebApiLog webApiLog = new WebApiLog();
                Boolean ny = webApiLog.setKingdeeJournal(key, name,BusinessNo, selectInList);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    list = materialinventoryWebapi.Materialinventory(selectInList);
                }
                break;
            }
        return list;

    }
}
