package org.jeecg.modules.iost.API.service.pojo.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.PhysicalIDApi;
import org.jeecg.modules.iost.API.entity.pojo.Physicalid;
import org.jeecg.modules.iost.API.mapper.pojo.PhysicalidMapper;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.pojo.IPhysicalidService;
import org.jeecg.modules.iost.API.webapi.PhysicalIDWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 国网实物ID信息API
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Slf4j
@Service
public class PhysicalidServiceImpl extends ServiceImpl<PhysicalidMapper,Physicalid> implements IPhysicalidService {
    private final static String name = "推送实物ID信息";
    private final static Integer BusinessNo = 7;
    @Autowired
    private PhysicalIDApi physicalIDApi;
    @Autowired
    private PhysicalIDWebapi physicalIDWebapi;
    @Autowired
    private IGridErrorService gridErrorService;



    @Override
    public Boolean synchronization(Object object) throws ParseException {
        Boolean success = true;
        Map<String, List<List<Object>>> stringListMap = null;
        if (object == null) {
            stringListMap = physicalIDWebapi.selectInList(null, new HashMap<String, String>() {{
                put("FApproveDate >", "'" + getTime() + "'");
//                put("FApproveDate >", "'2021-08-20 15:00:37.217'");
                put("FApproveDate <=", "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + "'");
            }});
        } else {
            stringListMap = physicalIDWebapi.selectWhere((String) object);

        }
        //解析金蝶返回数据转换为国网字段，获取的数据错误返回为空
        List<Map<String, String>> list = kingdeeAs(stringListMap);//记录金蝶日志

        if (list == null || list.size() < 1) return false;

        for (Map<String, String> stringStringMap : list) {
            String rs = physicalIDApi.add(stringStringMap);//数据转存国网
            JSONObject jsonObject = JSONObject.fromObject(rs);//获取国网返回
            gridErrorService.setGridError(jsonObject, stringStringMap, BusinessNo);//日志记录国网请求
            this.save(SplicingDetails(stringStringMap));//记录实物id明细
        }
        return success;
    }
    public List<Map<String, String>> kingdeeAs(Map<String, List<List<Object>>> stringListMap) throws ParseException {
        List<Map<String, String>> selectInList = null;
        if (stringListMap != null)
            for (String key : stringListMap.keySet()) {
                List<List<Object>> list = stringListMap.get(key);

                WebApiLog webApiLog = new WebApiLog();
                Boolean ny = webApiLog.setKingdeeJournal(key, name, BusinessNo, list);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    selectInList = physicalIDWebapi.PhysicalID(list);//字段转换
                }
                break;
            }
        return selectInList;
    }
    @Override
    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        Boolean aBoolean = false;
        String rs = physicalIDApi.add(stringStringMap);//数据转存国网
        JSONObject jsonObject = JSONObject.fromObject(rs);//获取国网返回
        Boolean aBoolean1 = gridErrorService.setGridError(jsonObject, stringStringMap, BusinessNo);//日志记录国网请求
        Boolean save = this.save(SplicingDetails(stringStringMap));//记录实物id明细
        aBoolean = aBoolean1 == save;
        return aBoolean;
    }

    public String getTime() {
        Physicalid Physicalid_time = this.getBaseMapper().selectOne(new QueryWrapper<Physicalid>().orderByDesc("fapprovedate").last("limit 1").select("fapprovedate"));
        String dateString = beforeDayByNowDay();
        if (Physicalid_time != null) {//非空判断
            if (Physicalid_time.getFapprovedate() != null) {
                Date fapprovedate = Physicalid_time.getFapprovedate();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                dateString = formatter.format(fapprovedate);
            }
        }
        return dateString;
    }
    /**
     * 获取当前日期的前一天
     * 需要返回的日期格式，例如：yyyy-MM-dd HH:mm:ss
     *
     * @return 前一天日期字符串
     */
    public String beforeDayByNowDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1); //得到前一天
        Date date = calendar.getTime();
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }
    //map转实体类
    public Physicalid SplicingDetails(Map<String, String> stringStringMap) throws ParseException {
        String fApproveDate = stringStringMap.get("FApproveDate");
        Physicalid physicalid = JSON.parseObject(JSON.toJSONString(stringStringMap), Physicalid.class);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date parse = null;
        parse = simpleDateFormat.parse(timeSSS(fApproveDate));//时间转换毫秒补丁
        physicalid.setFapprovedate(parse);

        return physicalid;
    }
    public String timeSSS(String selectedTimeStamp) {
        if (selectedTimeStamp.indexOf(".")>0) {
            int x = selectedTimeStamp.length() - selectedTimeStamp.lastIndexOf('.');
            if (x == 2)
                selectedTimeStamp += "00";
            if (x == 3)
                selectedTimeStamp += '0';
        }else {
            selectedTimeStamp += ".000";
        }
        return selectedTimeStamp;
    }
}
