package org.jeecg.modules.iost.API.service.pojo.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.ProductInventoryApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournal;
import org.jeecg.modules.iost.API.entity.pojo.Productinventory;
import org.jeecg.modules.iost.API.mapper.pojo.ProductinventoryPojoMapeer;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.IKingdeeJournalService;
import org.jeecg.modules.iost.API.service.pojo.IProductinventoryPojoService;
import org.jeecg.modules.iost.API.webapi.MaterialWebapi;
import org.jeecg.modules.iost.API.webapi.ProductInventoryWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.*;

/**
 * 产成品库存信息
 */
@Slf4j
@Service
public class ProductinventoryPojoServiceImpl extends ServiceImpl<ProductinventoryPojoMapeer, Productinventory> implements IProductinventoryPojoService {
    private final static String name = "产成品";
    private final static Integer BusinessNo = 9;
    @Autowired
    ProductInventoryApi productInventoryApi;

    @Autowired
    ProductInventoryWebapi productInventoryWebapi;

    @Autowired
    MaterialWebapi materialWebapi;

    @Autowired
    IKingdeeJournalService kingdeeJournalService;

    @Autowired
    IGridErrorService gridErrorService;

    /**
     * 将金蝶云中的即时库存中的今天的产成品信息同步到国网上
     * @param object
     * @return
     */
    @Override
    public Boolean synchronization(Object object) throws ParseException {
        //将返回信息保存在集合

        List<Productinventory> pojolist=new ArrayList<>();
        //查询今天更新的产成品
//        List<Map<String, String>> list =  productInventoryWebapi.select(null,null);
        Boolean success = true;
        Map<String, List<List<Object>>> synchronization = null;
        //拆解select-获取金蝶云星空的响应信息数据
        List<Map<String, String>> list = null;
        if (object == null) {
            synchronization = productInventoryWebapi.synchronization(null, null);
        } else {
            synchronization = productInventoryWebapi.synchronization((String) object);
        }
        //保存金蝶云操作的日志记录
        list = KingdeeLog(synchronization);
        if (list == null || list.size() < 1) return false;
        //设置金蝶日志
//        KingdeeLog(list);
        //遍历集合 将每个产成品的信息同步到国网
        for (Map<String,String> data:list) {
            Productinventory pojo = new Productinventory();
            //拿到每个物料编码
            String fmaterialid = data.get("productcode");
            //通过物料编码来确认是否是产成品
            List<Map<String, String>> select = materialWebapi.select(new HashMap<String,String>(){{
                put("FNumber",fmaterialid);
                put("F_LQKJ_IsProduct","1");//F_LQKJ_IsProduct
            }}, null);
            //如果是产出品就添加到国网
            if (!select.isEmpty()){
                //将存放到国网的数据本地备份
                pojo.setFid(data.get("fid"));
                pojo.setProductamount(data.get("productamount"));
                pojo.setProductcode(data.get("productcode"));
                pojo.setProductname(data.get("productname"));
                pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
                pojo.setDatasource("0");
                pojo.setProductunit(data.get("productunit"));
                pojolist.add(pojo);
                //添加到国网
                String rs = productInventoryApi.add(data);
                JSONObject jsonObject = JSONObject.fromObject(rs);

                //判断是否存到了国网上
                gridErrorService.setGridError(jsonObject,data,BusinessNo);
//                if(jsonObject.get("success")==null){
//                    physicaliderror.setMessage(jsonObject.get("message").toString());
//                    physicaliderror.setJson(JsonUtil.Mapjson(data));
//                    physicaliderror.setStatus((int)jsonObject.get("code"));
//                    physicaliderror.setCreatetime(new Date());
//                    physicaliderror.setSynchronization(1);
//                    lists.add(physicaliderror);
//                }else {
//                    //获取错误日志
//                    physicaliderror.setMessage(jsonObject.get("message").toString());
//                    physicaliderror.setJson(jsonObject.get("result").toString());
//                    physicaliderror.setStatus((int) jsonObject.get("code"));
//                    physicaliderror.setCreatetime(new Date());
//                    //同步字段设置为0
//                    physicaliderror.setSynchronization(0);
//                    lists.add(physicaliderror);
//                }
            }
        }
        //将所有的日志全部存放到数据库
        this.saveBatch(pojolist);
//        if (this.saveBatch(lists)){
//
//        }
        return success;
    }
    public Boolean grid(Map<String, String> data) throws ParseException {
        Boolean aBoolean=false;
        Productinventory pojo = new Productinventory();
        //拿到每个物料编码
        String fmaterialid = data.get("productcode");
        //通过物料编码来确认是否是产成品
        List<Map<String, String>> select = materialWebapi.select(new HashMap<String,String>(){{
            put("FNumber",fmaterialid);
            put("F_LQKJ_IsProduct","1");//F_LQKJ_IsProduct
        }}, null);
        //如果是产出品就添加到国网
        if (!select.isEmpty()) {
            //将存放到国网的数据本地备份
            pojo.setFid(data.get("fid"));
            pojo.setProductamount(data.get("productamount"));
            pojo.setProductcode(data.get("productcode"));
            pojo.setProductname(data.get("productname"));
            pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
            pojo.setDatasource("0");
            pojo.setProductunit(data.get("productunit"));
            //添加到国网
            String rs = productInventoryApi.add(data);
            JSONObject jsonObject = JSONObject.fromObject(rs);

            //判断是否存到了国网上
            Boolean aBoolean1 =gridErrorService.setGridError(jsonObject, data, BusinessNo);//日志记录国网请求

            Boolean save= this.save(pojo);//记录实物id明细

            aBoolean = aBoolean1 == save;
        }
        return aBoolean;
    }


    //设置金蝶的请求日志
    public List<Map<String, String>> KingdeeLog(Map<String, List<List<Object>>> synchronization) throws ParseException {
        List<List<Object>> selectInList = null;
        List<Map<String, String>> list = null;
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                selectInList = synchronization.get(key);
                WebApiLog webApiLog = new WebApiLog();
                Boolean ny = webApiLog.setKingdeeJournal(key, name,BusinessNo, selectInList);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    list = productInventoryWebapi.ProductInventory(selectInList);
                }
                break;
            }
        return list;

    }
}
