package org.jeecg.modules.iost.API.service.pojo.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.ProductionOrderApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.pojo.ProductionOrder;
import org.jeecg.modules.iost.API.mapper.pojo.ProductionOrderPojoMapper;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.pojo.IProductionOrderPojoService;
import org.jeecg.modules.iost.API.webapi.ProductionOrderWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 国网生产订单API
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Service
@Slf4j
public class ProductionOrderPojoServiceImpl extends ServiceImpl<ProductionOrderPojoMapper, ProductionOrder> implements IProductionOrderPojoService {
    private final static String name = "推送生产订单";
    private final static Integer BusinessNo = 4;
    @Autowired
    ProductionOrderApi productionOrderApi;
    @Autowired
    ProductionOrderWebapi productionOrderWebapi;
    @Autowired
    WebApiLog webApiLog;
    @Autowired
    IGridErrorService gridErrorService;
    //添加单个数据到国网-生产订单

    /**
     * 同步-(从金蝶云同步数据到国网端，并且对两方操作创建同步日志，明细实体保存)
     */
    @Override
    public Boolean synchronization(Object object) throws ParseException {
        Boolean success = true;
        Map<String, List<List<Object>>> synchronization = null;
        //拆解select-获取金蝶云星空的响应信息数据
        List<Map<String, String>> list = null;
        if (object == null) {
            synchronization = productionOrderWebapi.synchronization(null, null);
        } else {
            synchronization = productionOrderWebapi.synchronization((String) object);
        }
        //保存金蝶云操作的日志记录
        list = addKingdeeJournalProductionOrder(synchronization);

        if (list == null || list.size() < 1) return false;

        //从金蝶云查询数据(传给国网用)
//        List<Object> select = productionOrderWebapi.selectObject(null, null);
        //拆解select-获取传入金蝶云星空请求的条件数据
//        String content = (String) select.get(0);
        //拆解select-获取金蝶云星空的响应信息数据
//        List<Map<String, String>> list = (List<Map<String, String>>) select.get(1);
        //List<Map<String, String>> 转化成 List<List<Object>>
//        List<List<Object>> Lists = ListInsideMapChangeListInsideList(list);
        //保存金蝶云操作的日志记录
//        addKingdeeJournalProductionOrder(content, Lists);
        //创建list对象
//        ArrayList<Productionordererror> Productionordererrors = new ArrayList<>();
        ArrayList<ProductionOrder> productionOrders = new ArrayList<>();

        for (Map<String, String> stringStringMap : list) {
            // 向国网添加数据
            String rs = productionOrderApi.add(stringStringMap);
            //国网日志信息保存(里面进行判断)
            JSONObject jsonObject = JSONObject.fromObject(rs);
            gridErrorService.setGridError(jsonObject,stringStringMap,BusinessNo);
//            addProductionOrder(rs, stringStringMap, Productionordererrors);
            //明细实体类信息保存
            pojosave(stringStringMap, productionOrders); //保存明细实体
        }
        //明细实体类信息保存操作
        this.saveBatch(productionOrders);
        //国网日志保存操作
//        this.saveBatch(Productionordererrors);
        return success;
    }

    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        Boolean aBoolean=false;
        String rs = productionOrderApi.add(stringStringMap);//数据转存国网
        JSONObject jsonObject = JSONObject.fromObject(rs);//获取国网返回
        Boolean aBoolean1 = gridErrorService.setGridError(jsonObject, stringStringMap, BusinessNo);//日志记录国网请求
        ArrayList<ProductionOrder> productionOrders = new ArrayList<>();
        pojosave(stringStringMap, productionOrders); //保存明细实体
        Boolean save = this.saveBatch(productionOrders);//记录实物id明细
        aBoolean=aBoolean1==save;
        return aBoolean;
    }
    /*List<Map<String, String>> 转化成 List<List<Object>>*/
    public List<List<Object>> ListInsideMapChangeListInsideList(List<Map<String, String>> ListMap) {
        List<List<Object>> Listlist = new ArrayList<>();
        Object o = new Object();
        for (Map<String, String> stringStringMap : ListMap) {
            List<Object> Listobject = new ArrayList<>();
            for (String s : stringStringMap.keySet()) {
                o = (Object) stringStringMap.get(s);
                Listobject.add(o);
            }
            Listlist.add(Listobject);
        }
        return Listlist;
    }


    //保存金蝶云操作的日志记录
    public List<Map<String, String>> addKingdeeJournalProductionOrder(Map<String, List<List<Object>>> synchronization) throws ParseException {
        List<List<Object>> selectInList = null;
        List<Map<String, String>> list = null;
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                selectInList = synchronization.get(key);

                Boolean ny = webApiLog.setKingdeeJournal(key, name,BusinessNo, selectInList);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    list = productionOrderWebapi.ProductionOrder(selectInList);

                }
                break;
            }
        return list;

    }


    /*明细实体保存*/
    public void pojosave(Map<String, String> stringStringMap, ArrayList<ProductionOrder> productionOrders) {
        ProductionOrder p = new ProductionOrder();
        p.setDatasource(stringStringMap.get("datasource"));
        p.setPurchaserhqcode(stringStringMap.get("purchaserhqcode"));
        p.setAmount(stringStringMap.get("amount"));
        p.setIpotype(stringStringMap.get("ipotype"));
        p.setSuppliercode(stringStringMap.get("suppliercode"));
        p.setSuppliername(stringStringMap.get("suppliername"));
        p.setIpono(stringStringMap.get("ipono"));
        p.setCategorycode(stringStringMap.get("categorycode"));
        p.setSubclasscode(stringStringMap.get("subclasscode"));
        p.setSchedulecode(stringStringMap.get("schedulecode"));
        p.setPoitemid(stringStringMap.get("poitemid"));
        p.setDatatype(stringStringMap.get("datatype"));
        p.setSoitemno(stringStringMap.get("soitemno"));
        p.setMaterialscode(stringStringMap.get("materialscode"));
        p.setMaterialsname(stringStringMap.get("materialsname"));
        p.setMaterialsunit(stringStringMap.get("materialsunit"));
        p.setMaterialsdesc(stringStringMap.get("materialsdesc"));
        p.setUnit(stringStringMap.get("unit"));
        p.setProductidgrpno(stringStringMap.get("productidgrpno"));
        p.setProductidtype(stringStringMap.get("productidtype"));
        p.setProductmodel(stringStringMap.get("productmodel"));
        p.setPlanstartdate(stringStringMap.get("planstartdate"));
        p.setPlanfinishdate(stringStringMap.get("planfinishdate"));
        p.setActualstartdate(stringStringMap.get("actualstartdate"));
        p.setActualfinishdate(stringStringMap.get("actualfinishdate"));
        p.setPlantname(stringStringMap.get("plantname"));
        p.setWorkshopname(stringStringMap.get("workshopname"));
        p.setIpostatus(stringStringMap.get("ipostatus"));
        p.setCenter(stringStringMap.get("center"));
        p.setDatasourcecreatetime(stringStringMap.get("datasourcecreatetime"));
        p.setOwnerid(stringStringMap.get("ownerid"));
        p.setOpenid(stringStringMap.get("openid"));
        p.setFid(stringStringMap.get("fid"));
        productionOrders.add(p);
    }
}

