package org.jeecg.modules.iost.API.service.pojo.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.ProductionSchedulingApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.pojo.Productionscheduling;
import org.jeecg.modules.iost.API.mapper.pojo.ProductionschedulingPojoMapper;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.pojo.IProductionschedulingPojoService;
import org.jeecg.modules.iost.API.webapi.ProductionSchedulingWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 排产计划
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Service
@Slf4j
public class ProductionschedulingPojoServiceImpl extends ServiceImpl<ProductionschedulingPojoMapper, Productionscheduling> implements IProductionschedulingPojoService {
    private final static String name = "推送排产计划";
    private final static Integer BusinessNo = 5;
    @Autowired
    ProductionSchedulingApi productionSchedulingApi;
    @Autowired
    ProductionSchedulingWebapi productionSchedulingWebapi;
    @Autowired
    WebApiLog webApiLog;
    @Autowired
    IGridErrorService gridErrorService;


    /* 同步-(从金蝶云同步数据到国网端，并且对两方操作创建同步日志，明细实体保存) */
    @Override
    public Boolean synchronization(Object object) throws ParseException {
        Boolean success = true;
        Map<String, List<List<Object>>> synchronization = null;
        //拆解select-获取金蝶云星空的响应信息数据
        List<Map<String, String>> list = null;
        if (object == null) {
            synchronization = productionSchedulingWebapi.synchronization(null, null);
        } else {
            synchronization = productionSchedulingWebapi.synchronization((String) object);

        }
        //保存金蝶云操作的日志记录
        list = addKingdeeJournalProductionScheduling(synchronization);
        if (list == null || list.size() < 1) return false;

        //从金蝶云查询数据(传给国网用)
//        List<Object> select = productionSchedulingWebapi.selectObject(null, null);
        //拆解select-获取传入金蝶云星空请求的条件数据
//        String content = (String) select.get(0);
        //拆解select-获取金蝶云星空的响应信息数据
//        List<Map<String, String>> list = (List<Map<String, String>>) select.get(1);
        //List<Map<String, String>> 转化成 List<List<Object>>
//        List<List<Object>> Lists = ListInsideMapChangeListInsideList(list);
        //保存金蝶云操作的日志记录
//        addKingdeeJournalProductionScheduling(content, Lists);
        //创建list对象

//        ArrayList<Productionschedulingerror> productionschedulingerrors = new ArrayList<>();
        ArrayList<Productionscheduling> productionschedulings = new ArrayList<>();
        for (Map<String, String> stringStringMap : list) {
            // 向国网添加数据
            String rs = productionSchedulingApi.add(stringStringMap);
            //国网日志信息保存(里面进行判断)
            JSONObject jsonObject = JSONObject.fromObject(rs);
            gridErrorService.setGridError(jsonObject,stringStringMap,BusinessNo);
//            addProductionscheduling(rs, stringStringMap, productionschedulingerrors);
            //明细实体类信息保存
            pojosave(stringStringMap, productionschedulings);
        }
        //明细实体类信息保存操作
        this.saveBatch(productionschedulings);

        return success;
    }
    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        Boolean aBoolean=false;
        String rs = productionSchedulingApi.add(stringStringMap);//数据转存国网
        JSONObject jsonObject = JSONObject.fromObject(rs);//获取国网返回
        Boolean aBoolean1 = gridErrorService.setGridError(jsonObject, stringStringMap, BusinessNo);//日志记录国网请求
        ArrayList<Productionscheduling> productionschedulings = new ArrayList<>();
        pojosave(stringStringMap, productionschedulings);
        Boolean save = this.saveBatch(productionschedulings);//记录实物id明细
        aBoolean=aBoolean1==save;
        return aBoolean;
    }
    //保存金蝶云操作的日志记录
    public List<Map<String, String>> addKingdeeJournalProductionScheduling(Map<String, List<List<Object>>> synchronization) throws ParseException {
        List<List<Object>> selectInList = null;
        List<Map<String, String>> list = null;
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                selectInList = synchronization.get(key);

                Boolean ny = webApiLog.setKingdeeJournal(key, name, BusinessNo, selectInList);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    list = productionSchedulingWebapi.ProductionScheduling(selectInList);
                }
                break;
            }
        return list;

    }

    /*明细实体类信息保存*/
    public void pojosave(Map<String, String> stringStringMap, ArrayList<Productionscheduling> productionschedulings) {
        /*   Productionscheduling p = new Productionscheduling();*/
        Productionscheduling productionscheduling = JSON.parseObject(JSON.toJSONString(stringStringMap), Productionscheduling.class);//map转为实体类对象
/*        p.setPurchaserhqcode(stringStringMap.get("purchaserhqcode"));
        p.setSuppliercode(stringStringMap.get("suppliercode"));
        p.setSuppliername(stringStringMap.get("suppliername"));
        p.setPoitemid(Integer.valueOf(stringStringMap.get("poItemId")));
        p.setSchedulecode(stringStringMap.get("schedulecode"));
        p.setProvcocode(stringStringMap.get("provcocode"));
        p.setProvconame(stringStringMap.get("provconame"));
        p.setPlanperiod(stringStringMap.get("planperiod"));
        p.setActualperiod(stringStringMap.get("actualperiod"));
        p.setSchedule(stringStringMap.get("schedule"));
        p.setDuedate(stringStringMap.get("duedate"));
        p.setPlanstartdate(stringStringMap.get("planstartdate"));
        p.setPlanfinishdate(stringStringMap.get("planfinishdate"));
        p.setActualstartdate(stringStringMap.get("actualstartdate"));
        p.setActualfinishdate(stringStringMap.get("actualfinishdate"));
        p.setCategorycode(stringStringMap.get("categorycode"));
        p.setSubclasscode(stringStringMap.get("subclasscode"));
        p.setRemark(stringStringMap.get("remark"));
        p.setDatasource(stringStringMap.get("datasource"));
        p.setDatasourcecreatetime(stringStringMap.get("datasourcecreatetime"));
        p.setOwnerid(stringStringMap.get("ownerid"));
        p.setOpenid(stringStringMap.get("openid"));
        p.setFid(stringStringMap.get("fid"));*/
        productionschedulings.add(productionscheduling);
    }
}

