package org.jeecg.modules.iost.API.service.pojo.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.PurchaseorderApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.dto.EIP;
import org.jeecg.modules.iost.API.dto.kingdee.KingDeeReturn;
import org.jeecg.modules.iost.API.dto.kingdee.Result;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournalReturnProcess;
import org.jeecg.modules.iost.API.mapper.pojo.PurchaseorderMapper;
import org.jeecg.modules.iost.API.entity.pojo.Purchaseorder;
import org.jeecg.modules.iost.API.service.*;

import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.jeecg.modules.iost.API.webapi.SalesOrderWebapi;
import org.jeecg.modules.iost.API.webapi.Util.FieldChange;
import org.jeecg.modules.iost.API.webapi.Util.FieldConversion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 采购订单接口
 * @Author: jeecg-boot
 * @Date: 2021-07-09
 * @Version: V1.0
 */
@Service
@Slf4j
public class PurchaseorderServiceImpl extends ServiceImpl<PurchaseorderMapper, Purchaseorder> implements IPurchaseorderService {
    private final static String name = "获取合同和采购订单信息，生成销售订单";
    private final static Integer BusinessNo = 1;

    @Autowired
    private PurchaseorderApi purchaseorderApi;

    @Autowired
    private SalesOrderWebapi salesOrderWebapi;

    @Autowired
    private IKingdeeJournalReturnProcessService kingdeeJournalService;
    @Autowired
    private IGridErrorReturnProcessService gridErrorService;


    @Override
    public synchronized Map synchronization(Map object) throws IOException, ParseException {
        List<Purchaseorder> purchaseordersList = new ArrayList<>();
        Map<String, String> ReturnResult = new LinkedHashMap<String, String>() {{
            put("success", "false");
        }};
        int savekingdeestate = 0;
        Map map = null;
        if (null == object) {
            map = new HashMap() {{
                put("purchaserHqCode", "SGCC");
                put("supplierCode", "");
                put("supplierName", "共创");
                put("modifyStartTime", getTime());
                put("modifyEndTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            }};
        } else {
            map = object;
        }
        JSONObject jsonObject = JSONObject.fromObject(purchaseorderApi.selectList(map));
        if (null == jsonObject.get("success")) {
            //请求国网的返回信息
            JSONObject resultValue = JSONObject.fromObject(jsonObject.get("resultValue"));
            Object data = resultValue.get("data");//获取返回数据的 data对象
            List listData = JSON.parseObject(data.toString(), List.class, Feature.OrderedField);
            //格式转换
            //记录请求国网的返回信息
            Map<Boolean, String> booleanStringMap = gridErrorService.setGridError(jsonObject, JsonUtil.Mapjson(map), BusinessNo);
            String ReturnProcessId = "";//请求国网日志id
            if (booleanStringMap.containsKey(true)) {
                ReturnProcessId = booleanStringMap.get(true);
            }
            if (null != listData) {
                for (Object purchaseorder : listData) {
                    Map mapPurchaseorder = JSON.parseObject(purchaseorder.toString(), LinkedHashMap.class);
                    String kingdeeSaleOrder = FieldChange.changePurchaseorder(mapPurchaseorder);
                    String kingdeeReturn = salesOrderWebapi.addKingdee(kingdeeSaleOrder);//同步到金蝶
                    try {
                        KingDeeReturn kingDeeReturn = JSON.parseObject(kingdeeReturn, KingDeeReturn.class, Feature.OrderedField);
                        if (null != kingDeeReturn && null != kingDeeReturn.getResult()) {
                            Result result = kingDeeReturn.getResult();
                            if (!result.getId().equals("") && !result.getNumber().equals("")) {
                                mapPurchaseorder.put("FId", result.getId());
                                mapPurchaseorder.put("FNumber", result.getNumber());
                                //获取返回数据记录到记录明细
                                savekingdeestate = 1;
                                purchaseordersList.add(JSON.parseObject(JSON.toJSONString(mapPurchaseorder), Purchaseorder.class));
                            }
                        }
                        kingdeeJournalService.setUpdateKingdee(kingdeeSaleOrder, kingdeeReturn, ReturnProcessId, JsonUtil.Objectjson(mapPurchaseorder), BusinessNo, savekingdeestate);
                    } catch (Exception e) {
                    }
                }
                boolean b = this.saveBatch(purchaseordersList);
                if (b) {
                    ReturnResult.put("success", "true");
                }
            }
        }
        return ReturnResult;
    }
    @Override
    public synchronized Map manual(Map<String, Object> mapPurchaseorder, String ReturnProcessId) throws ParseException {
        Map<String, String> ReturnResult = new LinkedHashMap<String, String>() {{
            put("success", "false");
        }};
        Boolean fn = false;
        int savekingdeestate = 0;
        Purchaseorder purchaseorder = new Purchaseorder();
        String kingdeeSaleOrder = FieldChange.changePurchaseorder(mapPurchaseorder);
        String kingdeeReturn = salesOrderWebapi.addKingdee(kingdeeSaleOrder);//同步到金蝶
        try {
            KingDeeReturn kingDeeReturn = JSON.parseObject(kingdeeReturn, KingDeeReturn.class, Feature.OrderedField);
            if (null != kingDeeReturn && null != kingDeeReturn.getResult()) {
                Result result = kingDeeReturn.getResult();
                if (!result.getId().equals("") && !result.getNumber().equals("")) {
                    mapPurchaseorder.put("FId", result.getId());
                    mapPurchaseorder.put("FNumber", result.getNumber());
                    //获取返回数据记录到记录明细
                    savekingdeestate = 1;
                    purchaseorder = JSON.parseObject(JSON.toJSONString(mapPurchaseorder), Purchaseorder.class);
                    boolean save = save(purchaseorder);
                    if (save) {
                        ReturnResult.put("success", "true");
                    }
                }
            }
            kingdeeJournalService.setUpdateKingdee(kingdeeSaleOrder, kingdeeReturn, ReturnProcessId, JsonUtil.Objectjson(mapPurchaseorder), BusinessNo, savekingdeestate);
        } catch (Exception e) {
        }
        return ReturnResult;
    }

    /**
     * @return 同步成功日志表记录的国网数据最大时间
     */
    public String getTime() {
        Purchaseorder purchaseorder_api_time = this.getBaseMapper().selectOne(new QueryWrapper<Purchaseorder>().orderByDesc("modify_Time").last("limit 1").select("modify_Time"));
        Date currentTime = null;
        String dateString = null;
        dateString = beforeDayByNowDay();
        if (purchaseorder_api_time != null) {//非空判断
            if (purchaseorder_api_time.getModifyTime() != null)
                currentTime = purchaseorder_api_time.getModifyTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateString = formatter.format(currentTime);
        }
        return dateString;
    }

    /**
     * 获取当前日期的前一天
     * 需要返回的日期格式，例如：yyyy-MM-dd HH:mm:ss
     *
     * @return 前一天日期字符串
     */
    public String beforeDayByNowDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1); //得到前一天
        Date date = calendar.getTime();
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }




}
