package org.jeecg.modules.iost.API.service.pojo.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.ReserveStockApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournal;
import org.jeecg.modules.iost.API.entity.pojo.Reservestock;
import org.jeecg.modules.iost.API.mapper.pojo.ReservestockPojoMapeer;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.IKingdeeJournalService;
import org.jeecg.modules.iost.API.service.pojo.IReservestockPojoService;
import org.jeecg.modules.iost.API.webapi.MaterialWebapi;
import org.jeecg.modules.iost.API.webapi.ReserveStockWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 国网备品备件库存API
 * @Author: jeecg-boot
 * @Date: 2021-07-15
 * @Version: V1.0
 */
@Slf4j
@Service
public class ReservestockPojoServiceImpl extends ServiceImpl<ReservestockPojoMapeer, Reservestock> implements IReservestockPojoService {

    private final static String name = "备品备件";
    private final static Integer BusinessNo = 8;

    @Autowired
    ReserveStockApi reserveStockApi;
    @Autowired
    ReserveStockWebapi reserveStockWebapi;
    @Autowired
    MaterialWebapi materialWebapi;
    @Autowired
    IKingdeeJournalService kingdeeJournalService;
    @Autowired
    IGridErrorService gridErrorService;

    /**
     * 从金蝶云网站生产入库单获取今天的备品备件同步到国网
     *
     * @param object
     * @return
     */
    @Override
    public Boolean synchronization(Object object) throws ParseException {
        //将返回信息保存在集合
        List<Reservestock> pojolist = new ArrayList<>();
        //查询今天更新的备品
//        List<Map<String, String>> list =  reserveStockWebapi.select(null,null);

        //查询今天的入库单数据
        Boolean success = true;
        Map<String, List<List<Object>>> synchronization = null;
        //拆解select-获取金蝶云星空的响应信息数据
        List<Map<String, String>> list = null;
        if (object == null) {
            synchronization = reserveStockWebapi.synchronization(null, null);
        } else {
            synchronization = reserveStockWebapi.synchronization((String) object);

        }
        //保存金蝶云操作的日志记录
        list = KingdeeLog(synchronization);
        if (list == null || list.size() < 1) return false;
        //遍历集合 将每个备品的信息同步到国网
        for (Map<String, String> data : list) {
            Reservestock pojo = new Reservestock();
            //拿到每个物料编码
            String fmaterialid = data.get("spareproductcode");
            //通过物料编码来确认是否是备品
            List<Map<String, String>> select = materialWebapi.select(new HashMap<String, String>() {{
                put("FNumber", fmaterialid);
                put("F_LQKJ_IsBackup", "1");
            }}, null);
            //如果是备品就添加到国网
            if (!select.isEmpty()) {
                //将存放到国网的数据本地备份
                pojo.setFid(data.get("fid"));
                pojo.setFbillno(data.get("fbillno"));
                pojo.setSpareproductcode(data.get("spareproductcode"));
                pojo.setProductamount(data.get("productamount"));
                pojo.setProductdec(data.get("productdec"));
                pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
                pojo.setRemark(data.get("productunit"));
                pojo.setProductunit(data.get("remark"));
                pojo.setDatasource("0");
                pojolist.add(pojo);

                //添加到国网
                String rs = reserveStockApi.add(data);
                JSONObject jsonObject = JSONObject.fromObject(rs);
                //判断是否存到了国网上
                gridErrorService.setGridError(jsonObject, data, BusinessNo);
//                if(jsonObject.get("success")==null){
//                    reservestockerror.setMessage(jsonObject.get("message").toString());
//                    reservestockerror.setJson(JsonUtil.Mapjson(data));
//                    reservestockerror.setStatus((int)jsonObject.get("code"));
//                    reservestockerror.setCreatetime(new Date());
//                    reservestockerror.setSynchronization(1);
//                    lists.add(reservestockerror);
//                }else {
//                    //获取错误日志
//                    reservestockerror.setMessage(jsonObject.get("message").toString());
//                    reservestockerror.setJson(jsonObject.get("result").toString());
//                    reservestockerror.setStatus((int) jsonObject.get("code"));
//                    reservestockerror.setCreatetime(new Date());
//                    //同步字段设置为0
//                    reservestockerror.setSynchronization(0);
//                    lists.add(reservestockerror);
//                }
            }
        }
        //将所有的日志全部存放到数据库
        this.saveBatch(pojolist);
//        if (this.saveBatch(lists)){
//
//        }
        return success;
    }

    public Boolean grid(Map<String, String> data) throws ParseException {
        Boolean aBoolean = false;
        Reservestock pojo = new Reservestock();
        //拿到每个物料编码
        String fmaterialid = data.get("spareproductcode");
        //通过物料编码来确认是否是备品
        List<Map<String, String>> select = materialWebapi.select(new HashMap<String, String>() {{
            put("FNumber", fmaterialid);
            put("F_LQKJ_IsBackup", "1");
        }}, null);
        //如果是备品就添加到国网
        if (!select.isEmpty()) {
            //将存放到国网的数据本地备份
            pojo.setFid(data.get("fid"));
            pojo.setFbillno(data.get("fbillno"));
            pojo.setSpareproductcode(data.get("spareproductcode"));
            pojo.setProductamount(data.get("productamount"));
            pojo.setProductdec(data.get("productdec"));
            pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
            pojo.setRemark(data.get("productunit"));
            pojo.setProductunit(data.get("remark"));
            pojo.setDatasource("0");
            //添加到国网
            String rs = reserveStockApi.add(data);
            JSONObject jsonObject = JSONObject.fromObject(rs);
            //判断是否存到了国网上
            Boolean aBoolean1 = gridErrorService.setGridError(jsonObject, data, BusinessNo);//日志记录国网请求
            Boolean save = this.save(pojo);//记录实物id明细

            aBoolean = aBoolean1 == save;
        }
        return aBoolean;
    }

    //设置金蝶的请求日志
    public List<Map<String, String>> KingdeeLog(Map<String, List<List<Object>>> synchronization) throws ParseException {
        List<List<Object>> selectInList = null;
        List<Map<String, String>> list = null;
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                selectInList = synchronization.get(key);
                WebApiLog webApiLog = new WebApiLog();
                Boolean ny = webApiLog.setKingdeeJournal(key, name, BusinessNo, selectInList);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    list = reserveStockWebapi.ReserveStock(selectInList);
                }
                break;
            }
        return list;

    }
}

