package org.jeecg.modules.iost.API.service.pojo.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.SalesOrderApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.pojo.Salesorder;
import org.jeecg.modules.iost.API.mapper.pojo.SalesorderPojoMapper;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.pojo.ISalesorderPojoService;
import org.jeecg.modules.iost.API.webapi.SalesOrderWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 销售订单
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Service
@Slf4j
public class SalesorderPojoServiceImpl extends ServiceImpl<SalesorderPojoMapper, Salesorder> implements ISalesorderPojoService {
    private final static String name = "推送销售订单";
    private final static Integer BusinessNo = 3;
    @Autowired
    private SalesOrderApi salesOrderApi;
    @Autowired
    private SalesOrderWebapi salesOrderWebapi;

    @Autowired
    private IGridErrorService gridErrorService;

    /*同步-(从金蝶云同步数据到国网端，并且对两方操作创建同步日志，明细实体保存)*/
    @Override
    public Boolean synchronization(Object object) throws ParseException {
        Boolean success = true;
        Map<String, List<List<Object>>> synchronization = null;
        //拆解select-获取金蝶云星空的响应信息数据
        List<Map<String, String>> list = null;
        if (object == null) {
            synchronization = salesOrderWebapi.synchronization(null, null);
        } else {
            synchronization = salesOrderWebapi.synchronization((String) object);
        }
        //保存金蝶云操作的日志记录
        list=addKingdeeJournalSalesOrder(synchronization);
        if (list == null || list.size() < 1) return false;
        //从金蝶云查询数据(传给国网用)
//        List<Object> select = salesOrderWebapi.selectObject(null, null);
        //拆解select-获取传入金蝶云星空请求的条件数据
//        String content = (String) select.get(0);
        //拆解select-获取金蝶云星空的响应信息数据
//        List<Map<String, String>> list=(List<Map<String, String>>)select.get(1);
        //List<Map<String, String>> 转化成 List<List<Object>>
//        List<List<Object>> Lists = ListInsideMapChangeListInsideList(list);

        //创建list对象
//        ArrayList<Salesordererror> salesordererrors = new ArrayList<>();
        List<Salesorder> salesorders = new ArrayList<>();
        for (Map<String, String> stringStringMap : list) {
            // 向国网添加数据
            String rs = salesOrderApi.add(stringStringMap);
            JSONObject jsonObject = JSONObject.fromObject(rs);
            //国网日志信息保存(里面进行判断)
            gridErrorService.setGridError(jsonObject,stringStringMap,BusinessNo);
//            addSalesOrder(rs, stringStringMap, salesordererrors);
            //明细实体类信息保存
            pojosave(stringStringMap, salesorders);
        }
        //明细实体类信息保存操作
        this.saveBatch(salesorders);
        //国网日志保存操作
//        this.saveBatch(salesordererrors);
        return success;
    }

    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        Boolean aBoolean=false;
        String rs = salesOrderApi.add(stringStringMap);//数据转存国网
        JSONObject jsonObject = JSONObject.fromObject(rs);//获取国网返回
        Boolean aBoolean1 = gridErrorService.setGridError(jsonObject, stringStringMap, BusinessNo);//日志记录国网请求
        ArrayList<Salesorder> salesorders = new ArrayList<>();
        pojosave(stringStringMap, salesorders);
        Boolean save = this.saveBatch(salesorders);//记录实物id明细
        aBoolean=aBoolean1==save;
        return aBoolean;
    }
    /*List<Map<String, String>> 转化成 List<List<Object>>*/
    public List<List<Object>> ListInsideMapChangeListInsideList(List<Map<String, String>> ListMap) {
        List<List<Object>> Listlist = new ArrayList<>();
        Object o = new Object();
        for (Map<String, String> stringStringMap : ListMap) {
            List<Object> Listobject = new ArrayList<>();
            for (String s : stringStringMap.keySet()) {
                o = (Object) stringStringMap.get(s);
                Listobject.add(o);
            }
            Listlist.add(Listobject);
        }
        return Listlist;
    }

    //保存金蝶云操作的日志记录
    public List<Map<String, String>> addKingdeeJournalSalesOrder(Map<String, List<List<Object>>> synchronization) throws ParseException {
        List<List<Object>> selectInList = null;
        List<Map<String, String>> list = null;
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                selectInList = synchronization.get(key);
                WebApiLog webApiLog = new WebApiLog();
                Boolean ny = webApiLog.setKingdeeJournal(key, name,BusinessNo, selectInList);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    list = salesOrderWebapi.SalesOrder(selectInList);
                }
                break;
            }
        return list;
    }

    //明细实体保存
    public void pojosave(Map<String, String> stringStringMap, List<Salesorder> salesorders) {
        Salesorder s = new Salesorder();
        s.setPurchaserhqcode(stringStringMap.get("purchaserhqcode"));
        s.setSono(stringStringMap.get("sono"));
        s.setSuppliercode(stringStringMap.get("suppliercode"));
        s.setBuyercode(stringStringMap.get("buyercode"));
        s.setBuyername(stringStringMap.get("buyername"));
        s.setBuyerprovince(stringStringMap.get("buyerprovince"));
        s.setCategorycode(stringStringMap.get("categorycode"));
        s.setSubclasscode(stringStringMap.get("subclasscode"));
        s.setSostatus(stringStringMap.get("sostatus"));
        s.setSoitemno(stringStringMap.get("soitemno"));
        s.setPoitemid(stringStringMap.get("poitemid"));
        s.setProductcode(stringStringMap.get("productcode"));
        s.setProductname(stringStringMap.get("productname"));
        s.setProductunit(stringStringMap.get("productunit"));
        s.setProductamount(stringStringMap.get("productamount"));
        s.setOwnerid(stringStringMap.get("ownerid"));
        s.setOpenid(stringStringMap.get("openid"));
        s.setDatasource(stringStringMap.get("datasource"));
        s.setDatasourcecreatetime(stringStringMap.get("datasourcecreatetime"));
        s.setFid(stringStringMap.get("fid"));
        s.setFbillno(stringStringMap.get("fbillno"));
        salesorders.add(s);
    }
}

