package org.jeecg.modules.iost.API.service.pojo.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.ExternalInterface.SupplyListIApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournal;
import org.jeecg.modules.iost.API.entity.pojo.Supplylist;
import org.jeecg.modules.iost.API.mapper.pojo.SupplylistPojoMapeer;
import org.jeecg.modules.iost.API.service.IGridErrorService;
import org.jeecg.modules.iost.API.service.IKingdeeJournalService;
import org.jeecg.modules.iost.API.service.pojo.ISupplylistPojoService;
import org.jeecg.modules.iost.API.webapi.SupplyListWebapi;
import org.jeecg.modules.iost.API.webapi.Util.WebApiLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description: 供货单信息
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Service
@Slf4j
public class SupplylistPojoServiceImpl extends ServiceImpl<SupplylistPojoMapeer, Supplylist> implements ISupplylistPojoService {
    private final static String name = "供货单";
    private final static Integer BusinessNo = 2;
    @Autowired
    private SupplyListIApi supplyListIApi;
    @Autowired
    private SupplyListWebapi supplyListWebapi;
    @Autowired
    private IKingdeeJournalService kingdeeJournalService;
    @Autowired
    private IGridErrorService gridErrorService;

    @Override
    public String add(Map<String, String> map) {
        return null;
    }

    @Override
    public JSONObject select(Map<String, String> map) {
        return null;
    }

    /**
     * 从金蝶云同步今天创建的销售出库单信息
     *
     * @param object
     * @return
     */
    @Override
    public Boolean synchronization(Object object) throws ParseException {
        Boolean success = true;
        //将返回信息保存在集合

        List<Supplylist> pojolist = new ArrayList<>();
        //查询今天更新的销售出库单基本信息
        List<Map<String, String>> list = null;

        Map<String, List<List<Object>>> synchronization = null;

        if (object == null) {
            synchronization = supplyListWebapi.synchronization(null, null);
        } else {
            synchronization = supplyListWebapi.synchronization((String) object);

        }

        List<List<Object>> selectInList = null;
        if (synchronization != null)
            for (String key : synchronization.keySet()) {
                selectInList = synchronization.get(key);
                WebApiLog webApiLog = new WebApiLog();
                Boolean ny = webApiLog.setKingdeeJournal(key, name, BusinessNo, selectInList);
                if (ny) {//记录金蝶日志并判断是否转换国网字段
                    list = supplyListWebapi.SalesOrder(selectInList);
                }
                break;
            }
        if (list == null || list.size() < 1) return false;
        //遍历集合 将每个单据的物料信息同步到国网
        for (Map<String, String> data : list) {
            Supplylist pojo = new Supplylist();
            //将存放到国网的数据本地备份
            pojo.setFid(data.get("fid"));
            pojo.setSupplyno(data.get("supplyno"));
            pojo.setFbillno(data.get("fbillno"));
            pojo.setMaterialdesc(data.get("materialdesc"));
            pojo.setMaterialcode(data.get("materialcode"));
            pojo.setAmount(data.get("amount"));
            pojo.setMeasunit(data.get("measunit"));
            pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
            pojolist.add(pojo);
            //添加到国网
            String rs = supplyListIApi.add(data);
            JSONObject jsonObject = JSONObject.fromObject(rs);
            //判断是否存到了国网上
            gridErrorService.setGridError(jsonObject, data, BusinessNo);

        }
        //将所有的日志全部存放到数据库
        this.saveBatch(pojolist);

        return success;
    }

    public Boolean grid(Map<String, String> data) throws ParseException {
        Boolean aBoolean = false;
        String rs = supplyListIApi.add(data);//数据转存国网
        JSONObject jsonObject = JSONObject.fromObject(rs);//获取国网返回
        Boolean aBoolean1 = gridErrorService.setGridError(jsonObject, data, BusinessNo);//日志记录国网请求
        Supplylist pojo = new Supplylist();
        //将存放到国网的数据本地备份
        pojo.setFid(data.get("fid"));
        pojo.setSupplyno(data.get("supplyno"));
        pojo.setFbillno(data.get("fbillno"));
        pojo.setMaterialdesc(data.get("materialdesc"));
        pojo.setMaterialcode(data.get("materialcode"));
        pojo.setAmount(data.get("amount"));
        pojo.setMeasunit(data.get("measunit"));
        pojo.setDatasourcecreatetime(data.get("datasourcecreatetime"));
        Boolean save = this.save(pojo);//记录实物id明细
        aBoolean = aBoolean1 == save;
        return aBoolean;
    }

    /**
     * 设置金蝶的请求日志
     *
     * @param list
     */
    public void KingdeeLog(List<Map<String, String>> list) {

        KingdeeJournal kingdeeJournal = new KingdeeJournal();
        //设置金蝶云请求日志
        kingdeeJournal.setName("供货单");
        kingdeeJournal.setBusinessNo(BusinessNo);
        kingdeeJournal.setResponse(JsonUtil.Listjson(list));
        kingdeeJournal.setCreatetime(new Date());
        if (list == null || list.size() < 1 || list.get(0).size() <= 1) {//返回判断
            kingdeeJournal.setSynchronization(0);
        } else {
            kingdeeJournal.setSynchronization(1);
        }
        kingdeeJournalService.save(kingdeeJournal);
    }
}
