package org.jeecg.modules.iost.API.vo;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;

import java.io.Serializable;

/**
 * 接口返回数据格式
 */
@Data
@ApiModel(value = "接口返回对象", description = "接口返回对象")
public class Request<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 成功标志
     */
    @ApiModelProperty(value = "成功标志")
    private boolean success = true;

    /**
     * 返回处理消息
     */
    @ApiModelProperty(value = "返回处理消息")
    private String message = "操作成功！";

    /**
     * 返回代码
     */
    @ApiModelProperty(value = "返回代码")
    private Integer code = 0;

    /**
     * 返回数据对象 data
     */
    @ApiModelProperty(value = "返回数据对象")
    private T result;

    /**
     * 时间戳
     */
    @ApiModelProperty(value = "时间戳")
    private long timestamp = System.currentTimeMillis();
    /**
     * 来源系统标识，1：网关；2：品类管理中心
     */
    @ApiModelProperty(value = "来源系统标识")
    private int orisys;

    /**
     * 返回请求报文中的交易流水号，方便排查问题
     */
    @ApiModelProperty(value = "全局交易流水号")
    private String transno;

    /**
     * 返回请求报文中的操作类型标识，方便排查问题
     */
    @ApiModelProperty(value = "操作类型")
    private String operatetype;

    public Request() {

    }
    public Request(JSONObject jsonObject) {
        if ( jsonObject.containsKey("orisys")){
            orisys = (int)jsonObject.get("orisys");
        }
        if ( jsonObject.containsKey("transno")){
            transno = (String) jsonObject.get("transno");
        }
        if ( jsonObject.containsKey("operatetype")){
            operatetype = (String)jsonObject.get("operatetype");
        }
    }

    public Request<T> success(String message) {
        this.message = message;
        this.code = CommonConstant.SC_OK_200;
        this.success = true;
        return this;
    }

    @Deprecated
    public  Request<Object> ok() {
        Request<Object> r = new Request<Object>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setMessage("成功");
        r.setOrisys(this.orisys);
        r.setTransno(this.transno);
        r.setOperatetype(this.operatetype);
        return r;
    }

    @Deprecated
    public  Request<Object> ok(String msg) {
        Request<Object> r = new Request<Object>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setMessage(msg);
        r.setOrisys(this.orisys);
        r.setTransno(this.transno);
        r.setOperatetype(this.operatetype);
        return r;
    }

    @Deprecated
    public  Request<Object> ok(Object data) {
        Request<Object> r = new Request<Object>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setResult(data);
        r.setOrisys(this.orisys);
        r.setTransno(this.transno);
        r.setOperatetype(this.operatetype);
        return r;
    }

    public  <T> Request<T> OK() {
        Request<T> r = new Request<T>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setMessage("成功");
        r.setOrisys(this.orisys);
        r.setTransno(this.transno);
        r.setOperatetype(this.operatetype);
        return r;
    }

    public  <T> Request<T> OK(T data) {
        Request<T> r = new Request<T>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setResult(data);
        r.setOrisys(this.orisys);
        r.setTransno(this.transno);
        r.setOperatetype(this.operatetype);
        return r;
    }

    public  <T> Request<T> OK(String msg, T data) {
        Request<T> r = new Request<T>();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setMessage(msg);
        r.setResult(data);
        r.setOrisys(this.orisys);
        r.setTransno(this.transno);
        r.setOperatetype(this.operatetype);
        return r;
    }

    public  Request<Object> error(String msg) {
        return error(CommonConstant.SC_INTERNAL_SERVER_ERROR_500, msg);
    }

    public  Request<Object> error(int code, String msg) {
        Request<Object> r = new Request<Object>();
        r.setCode(code);
        r.setMessage(msg);
        r.setSuccess(false);
        return r;
    }

    public Request<T> error500(String message) {
        this.message = message;
        this.code = CommonConstant.SC_INTERNAL_SERVER_ERROR_500;
        this.success = false;
        return this;
    }

    /**
     * 无权限访问返回结果
     */
    public  Request noauth(String msg) {
        return error(CommonConstant.SC_JEECG_NO_AUTHZ, msg);
    }

    @JsonIgnore
    private String onlTable;
}
