package org.jeecg.modules.iost.API.webapi;

import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 物料是否是重点材料
 */
@Component
public class MaterialWebapi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "BD_MATERIAL";
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public MaterialWebapi(){
        /*查询字段*/
        key.put("FMATERIALID","FMATERIALID");//物料编码
        key.put("F_LQKJ_IsImportent","F_LQKJ_IsImportent");//是否为重点物料
        //F_LQKJ_IsBackup
        key.put("F_LQKJ_IsBackup","F_LQKJ_IsBackup");//是否为备品备件
        //F_LQKJ_IsProduct
        key.put("F_LQKJ_IsProduct","F_LQKJ_IsProduct");//是否为成品
    }

    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }


    /**
     * 查询对应物料是否为对应的材料
     * @param map
     * @param where
     * @param
     * @return
     */
    @Override
    public List<Map<String,String>> select(Map<String,String> map, String where) {
        List<List<Object>> list = categoryDao.select(sFormId,key, map);
        return Material(list);
    }
    /**
     * 物料字段转换国网字段
     * @return
     */
    private List<Map<String,String>> Material(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        for (List<Object> list1:list) {
            Map<String,String> salesordermap = new HashMap<>();
            //获得物料编码
            salesordermap.put("matcode",list1.get(0).toString());
            salesorderlist.add(salesordermap);
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
