package org.jeecg.modules.iost.API.webapi;

import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 供应商重点原材料库存
 */
@Component
public class MaterialinventoryWebapi implements web_api {
    /**操作的单据体名称*/
    //查询金蝶采购入库的表单ID
    private String sFormId = "STK_InStock";
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public MaterialinventoryWebapi(){
        /*查询字段*/
        key.put("FBILLNO","FBILLNO");//单据编码
        key.put("FMATERIALID","FMATERIALID");//物料编码
        key.put("FBASEUNITQTY","FBASEUNITQTY");//原库存数量
        key.put("FMaterialName","FMaterialName");//物料名称
        key.put("FDate","FDate");//日期
        key.put("FID","FID");//主键
    }
    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }

    @Override
    public List<Map<String,String>>select(Map<String,String> map,String where) {
        List<List<Object>> list = categoryDao.select(sFormId,key,new HashMap<String,String>(){{
            //只拿今天的数据
           // put("FBILLNO","CGRK29429");
            SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
            Date d1= new Date();
            String str1 = sdf1.format(d1);
            put("FDate",str1);
        }});
        return Materialinventory(list);
    }
    public Map<String, List<List<Object>>> synchronization(Map<String, String> map, String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectMap(sFormId, key,new HashMap<String,String>(){{
            //只拿今天的数据
            // put("FBILLNO","CGRK29429");
            SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
            Date d1= new Date();
            String str1 = sdf1.format(d1);
            put("FDate",str1);
        }});
        return stringListMap;
    }
    public Map<String, List<List<Object>>> synchronization(String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectMapWhere(sFormId, key,where);
        return stringListMap;
    }
    /**
     * 重点原材料字段转换国网字段
     * @return
     */
    public List<Map<String,String>> Materialinventory(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        for (List<Object> list1:list) {
            Map<String,String> salesordermap = new HashMap<>();
            //将字段名改变成国网数据库对应的字段名字
            salesordermap.put("fbillno",list1.get(0).toString());
            salesordermap.put("matcode",list1.get(1).toString());
            salesordermap.put("matnum",list1.get(2).toString());
            salesordermap.put("matname",list1.get(3).toString());
            salesordermap.put("datasourcecreatetime",new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            salesordermap.put("fid",list1.get(5).toString());
            salesorderlist.add(salesordermap);
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
