package org.jeecg.modules.iost.API.webapi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Dao.CategoryExecuteDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.pojo.Purchaseorder;
import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 实物ID信息
 */
@Component
public class PhysicalIDWebapi implements web_api {


    /**
     * 操作的单据体名称
     */
    private String sFormId = "PRD_INSTOCK";
    private String T_sFormId = "T_" + sFormId;
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();
    private List<String> keyList = new ArrayList<>();
    @Autowired
    private CategoryExecuteDao categoryExecuteDao;
    @Autowired
    private ProductionOrderWebapi productionOrderWebapi;
    @Autowired
    private IPurchaseorderService purchaseorderService;

    public PhysicalIDWebapi() {
        /*查询字段*/
        keyList.add("FBILLNO");//单据编码0
        keyList.add("FDATE");//日期1
        keyList.add("FMaterialId");//实物id2
        keyList.add("FDESCRIPTION");//备注3
        keyList.add("FCreateDate");//创建日期4
        keyList.add("FApproveDate");//审核时间5
        keyList.add("FID");//实体主键6
        keyList.add("FMoId");//生产订单内码7
    }

    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        /*查询字段*/
        key.put("FBILLNO", "FBILLNO");//单据编码
        key.put("FDESCRIPTION", "FDESCRIPTION");//备注
        key.put("FDATE", "FDATE");//日期
        List<List<Object>> list = categoryDao.select(sFormId, key, new HashMap<String, String>() {{
            put("FBILLNO", "SCRK00009865");
        }});
        return PhysicalID(list);
    }

    public Map<String, List<List<Object>>> selectInList(List<String> inList, Map<String, String> where) throws ParseException {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectInList(sFormId, keyList, where);

        return stringListMap;
    }

    public Map<String, List<List<Object>>> selectWhere(String where) throws ParseException {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectWhere(sFormId, keyList, where);
        return stringListMap;
    }

    /**
     * 实物ID字段转换国网字段
     *
     * @return
     */
    public List<Map<String, String>> PhysicalID(List<List<Object>> list) throws ParseException {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        Map<String, String> fid = new IdentityHashMap<String, String>();
        for (List<Object> list1 : list) {//获取生产订单id 拼接查询条件
            fid.put(new String("fid = "), list1.get(7).toString());
        }
        List<List<Object>> FSaleOrderIds = productionOrderWebapi.selectOr(fid);//查询关联生产订单

        List<List<Object>> f=new ArrayList<>();
        List<List<Object>> l=new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            String s = list.get(i).get(7).toString();
            label:for (int j = 0; j < FSaleOrderIds.size(); j++) {
                if (s.equals(FSaleOrderIds.get(j).get(1).toString())) {
                    f.add(list.get(i));
                    l.add(FSaleOrderIds.get(j));
                    FSaleOrderIds.remove(j);
                    break label;
                }
            }
        }

        int i = 0;
        for (List<Object> list1 : f) {
            Map<String, String> salesordermap = new HashMap<>();
            QueryWrapper<Purchaseorder> queryWrapper = new QueryWrapper<>();
            queryWrapper.select("po_Item_Id");
            Object SaleOrderId = l.get(i++).get(0);//销售订单id，可匹配过滤是否平台生成订单获取采购订单行项目号
            queryWrapper.eq("F_Id", SaleOrderId.toString());
            //查询是否为集成平台生成的订单，并过滤
            Purchaseorder purchaseorders1 = purchaseorderService.getBaseMapper().selectOne(queryWrapper);
            if (purchaseorders1 == null) continue;
            salesordermap.put("poItemId", purchaseorders1.getPoItemId());//采购订单行项目id
            String id = list1.get(0).toString();
            salesordermap.put("suppliercode", "linqin");//供应商编码
            salesordermap.put("purchaserhqcode", "SGCC");//采购方总部编码
            salesordermap.put("suppliername", "灵清科技");//供应商名称
            salesordermap.put("entitycode", list1.get(2).toString());//实物ID
            salesordermap.put("entitystatus", "2");//实物生产状态 0：未生产1：生产中2：生产完成
            salesordermap.put("datasource", "0");//数据来源 0：供应商，1：网关，2：代理
            salesordermap.put("datasourcecreatetime", StringDateFormatConversion(list1.get(4).toString(), "yyyy-MM-dd HH:mm:ss"));//来源数据创建时间
            salesordermap.put("remark", list1.get(3) == null ? null : list1.get(3).toString());//备注
            salesordermap.put("ownerid", id.substring(id.length() - 4));//数据拥有方
            salesordermap.put("openid", "string");//数据可见方
            salesordermap.put("FApproveDate", list1.get(5).toString());
            salesordermap.put("FBILLNO", list1.get(0).toString());
            salesordermap.put("FID", list1.get(6).toString());
            salesorderlist.add(salesordermap);
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }


    public String StringDateFormatConversion(String dateString, String formatdate) throws ParseException {
        if (dateString.equals("") || dateString == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss");
        SimpleDateFormat Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        parse = simpleDateFormat.parse(dateString);

        String format = Format.format(parse);
        return format;
    }
}