package org.jeecg.modules.iost.API.webapi;

import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 产成品库存信息
 */
@Component
public class ProductInventoryWebapi implements web_api {
    /**操作的单据体名称*/
    //从及时库存获取数据
    private String sFormId = "STK_Inventory";

    @Autowired
    private CategoryDao categoryDao;


    private Map<String,String> key = new LinkedHashMap<>();


    public ProductInventoryWebapi(){
        /*查询字段*/
        key.put("FLOT","FLOT");//批次号
        //FSecQty
        key.put("FBaseQty","FBaseQty");//库存量
        key.put("FMATERIALID","FMATERIALID");//物料编码
        //FMaterialName
        key.put("FMaterialName","FMaterialName");//物料名称
        key.put("FPRODUCEDATE","FPRODUCEDATE");//生产时间
        key.put("FUpdateTime","FUpdateTime");//最后入库时间
        key.put("FID","FID");//主键
    }

    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }

    /**
     * 从金蝶云上查询今天更新的即时库存信息
     * @param map
     * @param where
     * @return
     */
    public List<Map<String,String>>select(Map<String,String> map,String where) {
        SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
        Date d1= new Date();
        String str1 = sdf1.format(d1);
        //根据查询日期拿到明天
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d1);
        calendar.add(Calendar.DATE,1);
        String date=sdf1.format(calendar.getTime());
        Map<String, List<List<Object>>> list = categoryDao.selectdate(sFormId,key,new HashMap<String,String>(){{
            put("FUpdateTime",str1);
        }},date);
        List<List<Object>> lists = null;
        for (String s : list.keySet()) {
            lists = list.get(s);
            break;
        }
        return ProductInventory(lists);
    }
    public Map<String, List<List<Object>>> synchronization(Map<String, String> map, String where) {
        SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
        Date d1= new Date();
        String str1 = sdf1.format(d1);
        //根据查询日期拿到明天
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d1);
        calendar.add(Calendar.DATE,1);
        String date=sdf1.format(calendar.getTime());
        Map<String, List<List<Object>>> list = categoryDao.selectdate(sFormId,key,new HashMap<String,String>(){{
            put("FUpdateTime",str1);
        }},date);
        return list;
    }
    public Map<String, List<List<Object>>> synchronization(String where) {

        Map<String, List<List<Object>>> list = categoryDao.selectMapWhere(sFormId,key,where);
        return list;
    }
    /**
     * 转换国网字段
     * @param list
     * @return
     */
    public List<Map<String,String>>  ProductInventory(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        for (List<Object> list1:list) {
            Map<String,String> salesordermap = new HashMap<>();
            salesordermap.put("productamount",list1.get(1).toString());
            salesordermap.put("productcode",list1.get(2).toString());
            salesordermap.put("productname",list1.get(3).toString());
            salesordermap.put("datasourcecreatetime",new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            salesordermap.put("fid",list1.get(6).toString());
            salesorderlist.add(salesordermap);
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
