package org.jeecg.modules.iost.API.webapi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.pojo.Purchaseorder;
import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Description: 生产订单
 */
@Component
public class ProductionOrderWebapi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "PRD_MO";
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private IPurchaseorderService purchaseorderService;
    private Map<String,String> key = new LinkedHashMap<>();
    public ProductionOrderWebapi(){
        /*查询字段*/
        key.put("FCreateDate","FCreateDate");//单据创建时间 index 0
        key.put("FBILLNO","FBILLNO");//单据编码 index 1
        key.put("FBILLTYPE","FBILLTYPE");//单据类型 index 2
        key.put("FUNITID","FUNITID");//物料单位 index 3
        key.put("FMATERIALID","FMATERIALID");//物料编码 index 4
        key.put("FPLANSTARTDATE","FPLANSTARTDATE");//计划开始时间 index 5
        key.put("FYIELDQTY","FYIELDQTY");//成品数量 index 6
        key.put("FPLANFINISHDATE","FPLANFINISHDATE");//计划完成时间 index 7
        key.put("FMaterialName","FMaterialName");//物料名称 index 8
        key.put("FProductType","FProductType");//产品类型 index 9
        key.put("FGroup","FGroup");//组别 index 10
        key.put("FSpecification","FSpecification");//规格型号 index 11
        key.put("FWorkShopID","FWorkShopID");//生产车间 index 12
        key.put("FStatus","FStatus");//业务状态 index 13
        key.put("FID","FID");//主键 index 14
        key.put("FSaleOrderId", "FSaleOrderId ");//销售订单id index 15
    }

    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }

    @Override
    public List<Map<String,String>>select(Map<String,String> map,String where) {
/*        List<List<Object>> list = categoryDao.selectToday(sFormId,key);
        return ProductionOrder(list);*/
        return null;
    }
    public List<List<Object>> selectOr(Map<String, String> or) {
        LinkedHashMap<String, String> orkey = new LinkedHashMap<String, String>() {{
            put("FSaleOrderId", "FSaleOrderId ");
            put("FID","FID");
        }};
        List<List<Object>> lists = categoryDao.selectWhereOr(sFormId, orkey, or);
        return lists;
    }
    public Map<String, List<List<Object>>> synchronization(Map<String, String> map, String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectTodayAndReturnNew(sFormId, key);
        return stringListMap;
    }
    public Map<String, List<List<Object>>> synchronization(String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectMapWhere(sFormId, key,where);
        return stringListMap;
    }
    public List<Object>selectObject(Map<String,String> map,String where) {
        List<Object> lists = categoryDao.selectTodayAndReturn(sFormId, key);
        String content = (String)lists.get(0);
        //取出List<Object>第二个数据并且强转
        List<List<Object>> list=(List<List<Object>>)lists.get(1);
        //生产订单字段转换国网字段
        List<Map<String, String>> changelist = ProductionOrder(list);
        List<Object> objects = new ArrayList<Object>();
        objects.add(content);
        objects.add(changelist);
        return objects;
    }
    /**
     * 生产订单字段转换国网字段
     * @return
     */
    public List<Map<String,String>>  ProductionOrder(List<List<Object>> list){
        List<Map<String,String>> ProductionOrderlist = new ArrayList<>();
        if(!list.isEmpty()) {
            for (List<Object> list1 : list) {
                Map<String, String> ProductionOrdermap = new HashMap<>();
                QueryWrapper<Purchaseorder> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("F_Id");
                //销售订单id，可匹配过滤是否平台生成订单获取采购订单行项目号
                queryWrapper.eq("F_Id",list1.get(15).toString());//销售订单id index 15
                //查询是否为集成平台生成的订单，并过滤
                Purchaseorder purchaseorders1 = purchaseorderService.getBaseMapper().selectOne(queryWrapper);
                if (purchaseorders1==null) continue;
                ProductionOrdermap.put("poItemId",purchaseorders1.getPoItemId());//采购订单行项目id
                ProductionOrdermap.put("datasource", "0");//数据来源 (固定写成0)
                ProductionOrdermap.put("purchaserhqcode", "SGCC");//采购方总部编码 固定为"SGCC"
                ProductionOrdermap.put("datasourcecreatetime", SubStringT(list1.get(0).toString()));//来源数据创建时间
                ProductionOrdermap.put("ipono", list1.get(1).toString());//生产订单号
                ProductionOrdermap.put("ipotype", list1.get(2).toString());//订单类型
                ProductionOrdermap.put("materialsunit", list1.get(3).toString());//厂家物资单位
                ProductionOrdermap.put("materialscode", list1.get(4).toString());//厂家物料编码
                ProductionOrdermap.put("planstartdate", SubStringT(list1.get(5).toString()));//计划开始日期
                ProductionOrdermap.put("amount", list1.get(6).toString());//生产数量
                ProductionOrdermap.put("planfinishdate", SubStringT(list1.get(7).toString()));//计划完成日期
                ProductionOrdermap.put("materialsname", list1.get(8).toString());//厂家物料名称
                ProductionOrdermap.put("productidtype", list1.get(9).toString());//物资id类型
                ProductionOrdermap.put("productidgrpno", list1.get(10).toString());//物资id分组
                ProductionOrdermap.put("productmodel", list1.get(11).toString());//产品型号
                ProductionOrdermap.put("workshopname", list1.get(12).toString());//生产车间名称
                ProductionOrdermap.put("ipostatus", list1.get(13).toString());//生产订单状态
                ProductionOrdermap.put("fid", list1.get(14).toString());//实体主键 ，设置了后不能重复插入
                ProductionOrderlist.add(ProductionOrdermap);
            }
        }
        return ProductionOrderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }

    /*替换掉时间的字符串之中的'T'字符,用空格代替，以及截取毫秒字段，以符合国网传进的时间参数*/
    public String SubStringT(String s) {
        String replace = s.replace("T", " ");
        String replace1 = replace.replace(".", ",");
        String[] split = replace1.split(",");
        return split[0];
    }
}
