package org.jeecg.modules.iost.API.webapi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.ExternalInterface.PurchaseorderApi;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.pojo.Purchaseorder;
import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Description: 排产计划
 */
@Component
public class ProductionSchedulingWebapi implements web_api {
    @Autowired
    private PurchaseorderApi purchaseorderApi;
    @Autowired
    private CategoryDao categoryDao;
    @Autowired
    private ProductionOrderWebapi productionOrderWebapi;
    @Autowired
    private IPurchaseorderService purchaseorderService;
    /**操作的单据体名称*/
    private String sFormId = "PRD_MORPT";
    private Map<String,String> key = new LinkedHashMap<>();
    public ProductionSchedulingWebapi()
    {
        key.put("FCreateDate","FCreateDate");// 创建日期 index 0
        key.put("FID","FID");//主键 index 1
        key.put("FMoId ","FMoId ");//生产订单内码 index 2
    }


    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }

    @Override
    public List<Map<String,String>>select(Map<String,String> map,String where) {
    /*    List<List<Object>> list = categoryDao.selectToday(sFormId, key);
        return ProductionScheduling(list);*/
    return null;
    }
    public Map<String, List<List<Object>>> synchronization(Map<String, String> map, String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectTodayAndReturnNew(sFormId, key);

        return stringListMap;
    }
    public Map<String, List<List<Object>>> synchronization(String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectMapWhere(sFormId, key,where);

        return stringListMap;
    }
    public List<Object>selectObject(Map<String,String> map,String where) {
        List<Object> lists = categoryDao.selectTodayAndReturn(sFormId, key);
        String content = (String)lists.get(0);
        //取出List<Object>第二个数据并且强转
        List<List<Object>> list=(List<List<Object>>)lists.get(1);
        //排产计划字段转换国网字段
        List<Map<String, String>> changelist = ProductionScheduling(list);
        List<Object> objects = new ArrayList<Object>();
        objects.add(content);
        objects.add(changelist);
        return objects;
    }

    /**
     * 排产计划字段转换国网字段
     * @return
     *
     */
    public List<Map<String,String>>  ProductionScheduling(List<List<Object>> list){
        List<Map<String,String>> ProductionSchedulinglist = new ArrayList<>();



        if(!list.isEmpty()) {
            Map<String, String> fid = new IdentityHashMap<String, String>();
            for (List<Object> list1 : list) {//获取生产订单id 拼接查询条件
                fid.put(new String("fid = "), list1.get(2).toString());
            }
            List<List<Object>> FSaleOrderIds = productionOrderWebapi.selectOr(fid);//查询关联生产订单
            List<List<Object>> f=new ArrayList<>();
            List<List<Object>> l=new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                String s = list.get(i).get(2).toString();
                label:for (int j = 0; j < FSaleOrderIds.size(); j++) {
                    if (s.equals(FSaleOrderIds.get(j).get(1).toString())) {
                        f.add(list.get(i));
                        l.add(FSaleOrderIds.get(j));
                        FSaleOrderIds.remove(j);
                        break label;
                    }
                }
            }
            int i=0;
            for (List<Object> list1 : f) {
                Map<String, String> ProductionSchedulingmap = new HashMap<>();
                QueryWrapper<Purchaseorder> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("F_Id");
                Object SaleOrderId = l.get(i++).get(0);//销售订单id，可匹配过滤是否平台生成订单获取采购订单行项目号
                queryWrapper.eq("F_Id", SaleOrderId.toString());
                //查询是否为集成平台生成的订单，并过滤
                Purchaseorder purchaseorders1 = purchaseorderService.getBaseMapper().selectOne(queryWrapper);
                if (purchaseorders1==null) continue;
                ProductionSchedulingmap.put("poItemId",purchaseorders1.getPoItemId());//采购订单行项目id

                ProductionSchedulingmap.put("datasource", "0");//数据来源(固定写成0)
                ProductionSchedulingmap.put("purchaserhqcode", "SGCC"); //采购方总部编码 SGCC
                ProductionSchedulingmap.put("datasourcecreatetime", SubStringT(list1.get(0).toString())); //来源数据创建时间
                ProductionSchedulingmap.put("fid", list1.get(1).toString());//实体主键 ，设置了后不能重复插入
                ProductionSchedulinglist.add(ProductionSchedulingmap);
            }
        }
        return ProductionSchedulinglist;
    }

    @Override
    public String update(Object object) {
        return null;
    }

    /*替换掉时间的字符串之中的'T'字符,用空格代替，以及截取毫秒字段，以符合国网传进的时间参数*/
    public String SubStringT(String s) {
        String replace = s.replace("T", " ");
        String replace1 = replace.replace(".", ",");
        String[] split = replace1.split(",");
        return split[0];
    }
}