package org.jeecg.modules.iost.API.webapi;

import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 备品备件库存
 */
@Component
public class ReserveStockWebapi implements web_api {
    /**
     * 操作的单据体名称
     */
    //从生产入库单获取数据
    private String sFormId = "PRD_INSTOCK";
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public ReserveStockWebapi() {
        /*查询字段*/
        key.put("FMaterialId", "FMaterialId");//物料编码
        //FMaterialName
        key.put("FMaterialName", "FMaterialName");//物料名称
        key.put("FRealQty", "FRealQty");//实收数量
        key.put("FCreateDate", "FCreateDate");//创建时间
        key.put("FBillNo", "FBillNo");//单据编号
        key.put("FID", "FID");//主键
    }

    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }

    @Override
    /**
     * 从生产订单获取今天的物料信息
     */
    public List<Map<String, String>> select(Map<String, String> map, String where) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        Date d1 = new Date();
        String str1 = sdf1.format(d1);
        //根据查询日期拿到明天
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d1);
        calendar.add(Calendar.DATE, 1);
        String date = sdf1.format(calendar.getTime());
        Map<String, List<List<Object>>> list = categoryDao.selectdate(sFormId, key, new HashMap<String, String>() {{
            put("FCreateDate", str1);
        }}, date);
        List<List<Object>> lists = null;
        for (String s : list.keySet()) {
            lists = list.get(s);
            break;
        }
        return ReserveStock(lists);
    }

    /**
     * 从生产订单获取今天的物料信息
     */
    public Map<String, List<List<Object>>> synchronization(Map<String, String> map, String where) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        Date d1 = new Date();
        String str1 = sdf1.format(d1);
        //根据查询日期拿到明天
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d1);
        calendar.add(Calendar.DATE, 1);
        String date = sdf1.format(calendar.getTime());
        Map<String, List<List<Object>>> list=null;
        list= categoryDao.selectdate(sFormId, key, new HashMap<String, String>() {{
            put("FCreateDate", str1);
        }}, date);

        return list;
    }
    public Map<String, List<List<Object>>> synchronization(String where) {
        Map<String, List<List<Object>>> list=null;
        list= categoryDao.selectMapWhere(sFormId, key, where);

        return list;
    }
    /**
     * 备品备件库存字段转换国网字段
     *
     * @return
     */
    public List<Map<String, String>> ReserveStock(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        for (List<Object> list1 : list) {
            Map<String, String> salesordermap = new HashMap<>();
            salesordermap.put("spareproductcode", list1.get(0).toString());
            salesordermap.put("productamount", list1.get(2).toString());
            salesordermap.put("productdec", list1.get(1).toString());
            salesordermap.put("datasourcecreatetime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            salesordermap.put("fbillno", list1.get(4).toString());
            salesordermap.put("fid", list1.get(5).toString());
            salesorderlist.add(salesordermap);
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
