package org.jeecg.modules.iost.API.webapi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.pojo.Purchaseorder;
import org.jeecg.modules.iost.API.service.pojo.IPurchaseorderService;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Description: 销售订单WEBAPI
 * @Author: jeecg-boot
 * @Date: 2021-07-14
 * @Version: V1.0
 */
@Component
public class SalesOrderWebapi implements web_api {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "SAL_SaleOrder";
    private Map<String, String> key = new LinkedHashMap<>();
    @Autowired
    private IPurchaseorderService purchaseorderService;
    public SalesOrderWebapi() {
        /*查询字段*/

        key.put("FCreateDate", "FCreateDate");// 来源数据创建时间0
        key.put("FBillNo", "FBillNo");// 销售订单号1
        key.put("FDocumentStatus", "FDocumentStatus");// 销售订单状态2
        key.put("FMaterialId", "FMaterialId");// 物料编码3
        key.put("FMaterialName", "FMaterialName");// 物料名称4
        key.put("FUnitID", "FUnitID");// 物料单位5
        key.put("FQTY", "FQTY");//物料数量6
        key.put("FID", "FID");//主键7
        key.put("FBillNo","FBillNo ");//单据编号8
    }

    @Autowired
    private CategoryDao categoryDao;

    @Override
    public String add(Object object) {
        String json = categoryDao.add(sFormId, JsonUtil.Objectjson(object));
        return json;
    }
    public String addKingdee(String object) {
        String json = categoryDao.add(sFormId, object);
        return json;
    }
    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) {
   /*     List<List<Object>> list = categoryDao.selectToday(sFormId, key);
        return SalesOrder(list);*/
        return null;
    }

    public List<Object> selectObject(Map<String, String> map, String where) {
        List<Object> lists = categoryDao.selectTodayAndReturn(sFormId, key);
        String content = (String) lists.get(0);
        //取出List<Object>第二个数据并且强转
        List<List<Object>> list = (List<List<Object>>) lists.get(1);
        //销售订单字段转换国网字段
        List<Map<String, String>> changelist = SalesOrder(list);
        List<Object> objects = new ArrayList<Object>();
        objects.add(content);
        objects.add(changelist);
        return objects;
    }

    public Map<String, List<List<Object>>> synchronization(Map<String, String> map, String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectTodayAndReturnNew(sFormId, key);

        return stringListMap;
    }
    public Map<String, List<List<Object>>> synchronization(String where) {
        Map<String, List<List<Object>>> stringListMap = categoryDao.selectMapWhere(sFormId, key,where);

        return stringListMap;
    }
    /**
     * 销售订单字段转换国网字段
     *
     * @return
     */
    public List<Map<String, String>> SalesOrder(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            for (List<Object> list1 : list) {
                Map<String, String> salesordermap = new HashMap<>();
                QueryWrapper<Purchaseorder> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("F_Id");
                //销售订单id，可匹配过滤是否平台生成订单获取采购订单行项目号
                queryWrapper.eq("F_Id",list1.get(7).toString());
                //查询是否为集成平台生成的订单，并过滤
                Purchaseorder purchaseorders1 = purchaseorderService.getBaseMapper().selectOne(queryWrapper);
                if (purchaseorders1==null) continue;
                salesordermap.put("poItemId",purchaseorders1.getPoItemId());//采购订单行项目id
                salesordermap.put("suppliercode", "linqin");//供应商编码
                salesordermap.put("purchaserhqcode", "SGCC");//采购方总部编码 固定为"SGCC"
                salesordermap.put("datasource", "0");//数据来源(固定写成0)
                salesordermap.put("datasourcecreatetime", SubStringT(list1.get(0).toString()));//来源数据创建时间
                salesordermap.put("sono", list1.get(1).toString());//销售订单号
                salesordermap.put("sostatus", list1.get(2).toString());// 销售订单状态
                salesordermap.put("productcode", list1.get(3).toString());//物料编码
                salesordermap.put("productname", list1.get(4).toString());// 物料名称
                salesordermap.put("productunit", list1.get(5).toString());// 物料单位
                salesordermap.put("productamount", list1.get(6).toString());//物料数量
                salesordermap.put("fid", list1.get(7).toString());//实体主键 ，设置了后不能重复插入
                salesordermap.put("fbillno",list1.get(8).toString());//销售订单编码
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }

    /*替换掉时间的字符串之中的'T'字符,用空格代替，以及截取毫秒字段，以符合国网传进的时间参数*/
    public String SubStringT(String s) {
        String replace = s.replace("T", " ");
        String replace1 = replace.replace(".", ",");
        String[] split = replace1.split(",");
        return split[0];
    }

    //手动同步
    public String add(String kingdee) {
        String json = categoryDao.add(sFormId, kingdee);
        return json;
    }
}
