package org.jeecg.modules.iost.API.webapi;

import org.jeecg.modules.iost.API.Dao.CategoryDao;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.webapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 供货单信息
 */
@Component
public class SupplyListWebapi implements web_api {
    /**操作的单据体名称*/
    //查询销售出库单
    private String sFormId = "SAL_OUTSTOCK";
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public SupplyListWebapi(){
        /*查询字段*/
        key.put("FBillNo","FBillNo");//单据编码
        key.put("FDocumentStatus","FDocumentStatus");//单据状态
        key.put("FMaterialName","FMaterialName");//物料名字
        key.put("FMaterialID","FMaterialID");//物料编码
//        key.put("FCustMatID","FCustMatID");//客户物料编码 获取不到对应字段
//        key.put("FCustMatName","FCustMatName");//客户物料名字
        key.put("FCreateDate","FCreateDate");//创建日期
        key.put("FBaseUnitQty","FBaseUnitQty");//库存基本数量
        key.put("FUnitID","FUnitID");//库存单位
        key.put("FID","FID");//主键
    }

    @Override
    public String add(Object object) {
        return categoryDao.add(sFormId, JsonUtil.Objectjson(object));
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    //    @Override
    public Map<String, List<List<Object>>> synchronization(Map<String,String> map,String where) {
        SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
        Date d1= new Date();
        String str1 = sdf1.format(d1);
        //根据查询日期拿到明天
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d1);
        calendar.add(Calendar.DATE,1);
        String date=sdf1.format(calendar.getTime());
        Map<String, List<List<Object>>> fCreateDate = categoryDao.selectdate(sFormId, key, new HashMap<String, String>() {{
            put("FCreateDate", str1);
        }}, date);
//        List<List<Object>> list = (List<List<Object>>) fCreateDate;
        return fCreateDate;
    }

    public Map<String, List<List<Object>>> synchronization(String where) {
        Map<String, List<List<Object>>> fCreateDate = categoryDao.selectMapWhere(sFormId, key, where);
        return fCreateDate;
    }
    /**
     * 供货单字段转换国网字段
     * @return
     */
    public List<Map<String,String>> SalesOrder(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        for (List<Object> list1:list) {
            Map<String,String> salesordermap = new HashMap<>();
            salesordermap.put("purchaserHqCode","SGCC");
            salesordermap.put("supplyno",list1.get(0).toString());
            salesordermap.put("fbillno",list1.get(0).toString());
            salesordermap.put("materialdesc",list1.get(2).toString());
            salesordermap.put("materialcode",list1.get(3).toString());
//            salesordermap.put("eipmaterialcode",list1.get(4).toString()); 获取不到对应字段
//            salesordermap.put("eipmaterialdesc",list1.get(5).toString());
            salesordermap.put("amount",list1.get(5).toString());
            salesordermap.put("measunit",list1.get(6).toString());
            salesordermap.put("datasourcecreatetime",new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            salesordermap.put("fid",list1.get(7).toString());
            salesorderlist.add(salesordermap);
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
