package org.jeecg.modules.iost.API.webapi.Util;

import net.sf.json.JSONObject;
import org.jeecg.modules.iost.API.Util.JsonUtil;
import org.jeecg.modules.iost.API.entity.kingdeejournal.KingdeeJournal;
import org.jeecg.modules.iost.API.service.IKingdeeJournalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * 2021-08-18
 */
@Component
@Scope("prototype")
public class WebApiLog {

    @Autowired
    IKingdeeJournalService kingdeeJournalService;
    private static WebApiLog uploadRooms;

    @PostConstruct
    public void init() {
        uploadRooms = this;
        uploadRooms.kingdeeJournalService = this.kingdeeJournalService;
    }

    public Boolean setKingdeeJournal(String setRequest, String setName, Integer businessNo, List<List<Object>> setResponse) throws ParseException {
        boolean ny = false;
        KingdeeJournal kingdeeJournal = new KingdeeJournal();
        kingdeeJournal.setRequest(setRequest);
        kingdeeJournal.setName(setName);
        kingdeeJournal.setResponse(JsonUtil.Listjson(setResponse));
        kingdeeJournal.setBusinessNo(businessNo);
        kingdeeJournal.setCreatetime(new Date());
        if (null == setResponse && 0 == setResponse.size()) return false;
        if (setResponse.size() == 1 && setResponse.get(0).size() == 1 && JSONObject.fromObject(setResponse.get(0)).get("Result") != null) {//判断请求是否错误
            kingdeeJournal.setSynchronization(0);
            ny = false;
        } else {
            kingdeeJournal.setSynchronization(1);
            ny = true;
        }
        WebApiLog.uploadRooms.kingdeeJournalService.save(kingdeeJournal);//

        return ny;
    }

}
