package org.jeecg.modules.iost.basedata.controller;

import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostCustomerlist;
import org.jeecg.modules.iost.basedata.entity.IostCustomer;
import org.jeecg.modules.iost.basedata.vo.IostCustomerPage;
import org.jeecg.modules.iost.basedata.service.IIostCustomerService;
import org.jeecg.modules.iost.basedata.service.IIostCustomerlistService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 客户管理
 * @Author: jeecg-boot
 * @Date:   2020-12-15
 * @Version: V1.0
 */
@Api(tags="客户管理")
@RestController
@RequestMapping("/basedata/iostCustomer")
@Slf4j
public class IostCustomerController {
	@Autowired
	private IIostCustomerService iostCustomerService;
	@Autowired
	private IIostCustomerlistService iostCustomerlistService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostCustomer
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "客户管理-分页列表查询")
	@ApiOperation(value="客户管理-分页列表查询", notes="客户管理-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostCustomer iostCustomer,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostCustomer> queryWrapper = QueryGenerator.initQueryWrapper(iostCustomer, req.getParameterMap());
		Page<IostCustomer> page = new Page<IostCustomer>(pageNo, pageSize);
		IPage<IostCustomer> pageList = iostCustomerService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostCustomerPage
	 * @return
	 */
	@AutoLog(value = "客户管理-添加")
	@ApiOperation(value="客户管理-添加", notes="客户管理-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostCustomerPage iostCustomerPage) {
		IostCustomer iostCustomer = new IostCustomer();
		BeanUtils.copyProperties(iostCustomerPage, iostCustomer);
		iostCustomerService.saveMain(iostCustomer, iostCustomerPage.getIostCustomerlistList());
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param iostCustomerPage
	 * @return
	 */
	@AutoLog(value = "客户管理-编辑")
	@ApiOperation(value="客户管理-编辑", notes="客户管理-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostCustomerPage iostCustomerPage) {
		IostCustomer iostCustomer = new IostCustomer();
		BeanUtils.copyProperties(iostCustomerPage, iostCustomer);
		IostCustomer iostCustomerEntity = iostCustomerService.getById(iostCustomer.getId());
		if(iostCustomerEntity==null) {
			return Result.error("未找到对应数据");
		}
		iostCustomerService.updateMain(iostCustomer, iostCustomerPage.getIostCustomerlistList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "客户管理-通过id删除")
	@ApiOperation(value="客户管理-通过id删除", notes="客户管理-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostCustomerService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "客户管理-批量删除")
	@ApiOperation(value="客户管理-批量删除", notes="客户管理-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostCustomerService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "客户管理-通过id查询")
	@ApiOperation(value="客户管理-通过id查询", notes="客户管理-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostCustomer iostCustomer = iostCustomerService.getById(id);
		if(iostCustomer==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostCustomer);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "送货地址通过主表ID查询")
	@ApiOperation(value="送货地址主表ID查询", notes="送货地址-通主表ID查询")
	@GetMapping(value = "/queryIostCustomerlistByMainId")
	public Result<?> queryIostCustomerlistListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostCustomerlist> iostCustomerlistList = iostCustomerlistService.selectByMainId(id);
		return Result.OK(iostCustomerlistList);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostCustomer
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostCustomer iostCustomer) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostCustomer> queryWrapper = QueryGenerator.initQueryWrapper(iostCustomer, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostCustomer> queryList = iostCustomerService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostCustomer> iostCustomerList = new ArrayList<IostCustomer>();
      if(oConvertUtils.isEmpty(selections)) {
          iostCustomerList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostCustomerList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostCustomerPage> pageList = new ArrayList<IostCustomerPage>();
      for (IostCustomer main : iostCustomerList) {
          IostCustomerPage vo = new IostCustomerPage();
          BeanUtils.copyProperties(main, vo);
          List<IostCustomerlist> iostCustomerlistList = iostCustomerlistService.selectByMainId(main.getId());
          vo.setIostCustomerlistList(iostCustomerlistList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "客户管理列表");
      mv.addObject(NormalExcelConstants.CLASS, IostCustomerPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("客户管理数据", "导出人:"+sysUser.getRealname(), "客户管理"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostCustomerPage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostCustomerPage.class, params);
              for (IostCustomerPage page : list) {
                  IostCustomer po = new IostCustomer();
                  BeanUtils.copyProperties(page, po);
                  iostCustomerService.saveMain(po, page.getIostCustomerlistList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
