package org.jeecg.modules.iost.basedata.controller;

import java.io.UnsupportedEncodingException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecg.modules.iost.basedata.entity.*;
import org.jeecg.modules.iost.basedata.service.*;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.vo.IostDeliveryNotePage;
import org.jeecg.modules.iost.basedata.vo.IostDeliveryRecordPage;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: delivery note
 * @Author: jeecg-boot
 * @Date:   2020-11-20
 * @Version: V1.0
 */
@Api(tags="delivery note")
@RestController
@RequestMapping("/basedata/iostDeliveryNote")
@Slf4j
public class IostDeliveryNoteController {
	@Autowired
	private IIostDeliveryNoteService iostDeliveryNoteService;
	@Autowired
	private IIostDeliveryNoteListService iostDeliveryNoteListService;
	@Autowired
	private IIostDeliveryRecordPicService iostDeliveryRecordPicService;
	@Autowired
    private IIostSummarySheetListService iostSummarySheetListService;
     @Autowired
     private IIostSummarySheetService iostSummarySheetService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostDeliveryNote
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "delivery note-分页列表查询")
	@ApiOperation(value="delivery note-分页列表查询", notes="delivery note-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostDeliveryNote iostDeliveryNote,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostDeliveryNote> queryWrapper = QueryGenerator.initQueryWrapper(iostDeliveryNote, req.getParameterMap());
		Page<IostDeliveryNote> page = new Page<IostDeliveryNote>(pageNo, pageSize);
		IPage<IostDeliveryNote> pageList = iostDeliveryNoteService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostDeliveryNotePage
	 * @return
	 */
	@AutoLog(value = "delivery note-添加")
	@ApiOperation(value="delivery note-添加", notes="delivery note-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostDeliveryNotePage iostDeliveryNotePage) {
		IostDeliveryNote iostDeliveryNote = new IostDeliveryNote();
		BeanUtils.copyProperties(iostDeliveryNotePage, iostDeliveryNote);
		iostDeliveryNoteService.saveMain(iostDeliveryNote, iostDeliveryNotePage.getIostDeliveryNoteListList());
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param iostDeliveryNotePage
	 * @return
	 */
	@AutoLog(value = "delivery note-编辑")
	@ApiOperation(value="delivery note-编辑", notes="delivery note-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostDeliveryNotePage iostDeliveryNotePage) {
		IostDeliveryNote iostDeliveryNote = new IostDeliveryNote();
		BeanUtils.copyProperties(iostDeliveryNotePage, iostDeliveryNote);
		IostDeliveryNote iostDeliveryNoteEntity = iostDeliveryNoteService.getById(iostDeliveryNote.getId());
		if(iostDeliveryNoteEntity==null) {
			return Result.error("未找到对应数据");
		}
		iostDeliveryNoteService.updateMain(iostDeliveryNote, iostDeliveryNotePage.getIostDeliveryNoteListList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *  编辑
	 *
	 * @param iostDeliveryRecordPage
	 * @return
	 */
	@AutoLog(value = "delivery note-编辑")
	@ApiOperation(value="delivery note-编辑", notes="delivery note-编辑")
	@PostMapping(value = "/edit4Pic")
	public Result<?> edit4Pic(@RequestBody IostDeliveryRecordPage iostDeliveryRecordPage) {
		IostDeliveryRecord4Pics iostDeliveryNote = new IostDeliveryRecord4Pics();
		BeanUtils.copyProperties(iostDeliveryRecordPage, iostDeliveryNote);
		IostDeliveryRecord4Pics iostDeliveryNoteEntity = iostDeliveryNoteService.queryById4Pic(iostDeliveryNote.getId());
		if(iostDeliveryNoteEntity==null) {
			return Result.error("未找到对应数据");
		}
		iostDeliveryNoteService.updateMain4Pic(iostDeliveryNote);
		return Result.OK("编辑成功!");
	}

	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "delivery note-通过id查询")
	@ApiOperation(value="delivery note-通过id查询", notes="delivery note-通过id查询")
	@GetMapping(value = "/queryById4Pic")
	public Result<?> queryById4Pic(@RequestParam(name="id",required=true) String id) {
		IostDeliveryRecord4Pics iostDeliveryNote = iostDeliveryNoteService.queryById4Pic(id);
		if(iostDeliveryNote==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostDeliveryNote);

	}

	@AutoLog(value = "送货单-下载报表")
    @GetMapping("/exportDeliveryNotePicPdf")
    @ApiOperation(value = "下载送货单报表（pdf）")
	public void exportDeliveryNotePicPdf(HttpServletResponse response, @RequestParam(name="deliveryRecordId",required=true) String deliveryRecordId) throws IOException, DocumentException {
        QueryWrapper<IostSummarySheet> iostSummarySheetQueryWrapper = new QueryWrapper<>();
        iostSummarySheetQueryWrapper.eq("delivery_record_id", deliveryRecordId);
        IostSummarySheet iostSummarySheets = iostSummarySheetService.getBaseMapper().selectOne(iostSummarySheetQueryWrapper);
        List<IostSummarySheetList> iostSummarySheetLists = iostSummarySheetListService.selectByMainId(iostSummarySheets.getId());
        List<IostDeliveryRecordPic> recordPics = new ArrayList<>();
        for (IostSummarySheetList iostSummarySheetList:iostSummarySheetLists) {
            recordPics.add(iostDeliveryRecordPicService.getBaseMapper().selectById(iostSummarySheetList.getId()));
        }
        String fileName = "Delivery Note";
        response.setContentType("application/x-download");
        response.addHeader("Content-Disposition", "attachment;filename="+new String(fileName.getBytes("utf-8"), "ISO8859-1" )+".pdf");

        //加载字体
        //BaseFont bfChinese = BaseFont.createFont("/wmssystem/config/res/stsong.ttf", BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);
        BaseFont bfChinese = BaseFont.createFont("/res/stsong.ttf", BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);
        //Create Document Instance
        Document document = new Document(PageSize.A4);
        Font textFont = new Font(bfChinese, 6, Font.NORMAL);
        
        PdfWriter.getInstance(document, response.getOutputStream());
        document.open();
        if(recordPics.size() == 0)
        {
            document.newPage();
            addTitle(document, textFont);
        }
		try
		{
			for(IostDeliveryRecordPic iostDeliveryRecordPic:recordPics)
			{
	            document.newPage();
	            addTitle(document, textFont);
	            PdfPTable detailTable = new PdfPTable(1);
	            detailTable.setWidthPercentage(100f);
				List<Image> img = getImg(iostDeliveryRecordPic) ;
                for (Image imagelist: img) {

                    PdfPCell cell = new PdfPCell(imagelist);cell.setBorder(PdfPCell.NO_BORDER);cell.setHorizontalAlignment(Element.ALIGN_LEFT);detailTable.addCell(cell);
                }
		        //cell.setFixedHeight(img.getHeight() * (60 / img.getWidth()));cell.setFixedHeight(200);
	            document.add(detailTable);
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			log.info(ex.getMessage());
            document.newPage();
            addTitle(document, textFont);
		}

        //关闭流
        document.close();
		
	}
	
    /**
     * 获取图片img
     * @param flag 1 url形式   2本地存储形式
     * @return
     */
    public List<Image> getImg(IostDeliveryRecordPic iostDeliveryRecordPic) throws IOException, BadElementException {
        List<Image> imageList = new ArrayList<>();
        //获取字符串
        String string = iostDeliveryRecordPic.getPic();
        //分割字符串
        String substring = string.substring(0, string.length());
        String[] result = substring.split(",");
        for (int i = 0; i<result.length;i++){
            Image img = Image.getInstance("/公司专用文件/wmssystem/storage/opt/upFiles/" + result[i]);
            imageList.add(img);
        }

        return imageList;
    }


	@AutoLog(value = "送货单-下载报表")
    @GetMapping("/exportDeliveryNotePdf")
    @ApiOperation(value = "下载送货单报表（pdf）")
	public void exportDeliveryNotePdf(HttpServletResponse response, @RequestParam(name="deliveryRecordId",required=true) String deliveryRecordId) throws IOException, DocumentException {

    	QueryWrapper<IostDeliveryNote> iostReceivingNoteQueryWrapper = new QueryWrapper<>();
    	iostReceivingNoteQueryWrapper.eq("delivery_record_id", deliveryRecordId);
    	
    	List<IostDeliveryNote> iostReceivingNotes = iostDeliveryNoteService.list(iostReceivingNoteQueryWrapper);
    	
    	List<String> iostReceivingNoteIds = new ArrayList<String>();
    	for(IostDeliveryNote iostReceivingNote:iostReceivingNotes)
    	{
    		iostReceivingNoteIds.add(iostReceivingNote.getId());
    	}
    	
    	List<IostDeliveryNoteList> iostReceivingNoteLists = new  ArrayList<IostDeliveryNoteList>();
    	if(!iostReceivingNoteIds.isEmpty())
    	{
        	QueryWrapper<IostDeliveryNoteList> queryWrapper = new QueryWrapper<>();
            queryWrapper
                    .in("delivery_note_id", iostReceivingNoteIds);
    		iostReceivingNoteLists = iostDeliveryNoteListService.list(queryWrapper);
    	}
    	 
        String fileName = "Delivery Note";
        response.setContentType("application/x-download");
        response.addHeader("Content-Disposition", "attachment;filename="+new String(fileName.getBytes("utf-8"), "ISO8859-1" )+".pdf");

        //Create Document Instance
        Document document = new Document(PageSize.A4);

        //加载字体
        //BaseFont bfChinese = BaseFont.createFont("/wmssystem/config/res/stsong.ttf", BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);
        BaseFont bfChinese = BaseFont.createFont("/res/stsong.ttf", BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);
        //字体
        Font titleFont = new Font(bfChinese, 20, Font.BOLD);
        Font keyFont = new Font(bfChinese, 8, Font.NORMAL);
        Font textFont = new Font(bfChinese, 6, Font.NORMAL);

        //Create Writer associated with document
        PdfWriter.getInstance(document, response.getOutputStream());
        document.open();
        if(iostReceivingNotes.size() == 0)
        {
            document.newPage();
            addTitle(document, textFont);
        }
        for(IostDeliveryNote iostReceivingNote:iostReceivingNotes)
        {
            document.newPage();
            addTitle(document, textFont);
            addTopInfo(document, titleFont, keyFont, textFont);
            //加载标题、日期
            addDeliveryNoteTitleAndDateInfo(document, titleFont, keyFont);
        	List<IostDeliveryNoteList> iostReceivingNoteListList = new ArrayList<IostDeliveryNoteList>();
        	
        	for(IostDeliveryNoteList iostReceivingNoteList:iostReceivingNoteLists)
        	{
        		if(!iostReceivingNoteList.getDeliveryNoteId().equals(iostReceivingNote.getId())) continue;
        		
        		iostReceivingNoteListList.add(iostReceivingNoteList);
        	}
        	addDeliveryNoteHeadField(document, iostReceivingNote, keyFont, textFont);
            //添加统计表格信息
        	addDeliveryNoteEntryTable(document, iostReceivingNoteListList, keyFont, textFont);
        	addEnd(document, keyFont, textFont);
        }
        //关闭流
        document.close();

	}
	
	private void addTitle(Document document, Font smtextFont) throws DocumentException
	{        
		PdfPTable t = new PdfPTable(3);
	    float[] widths = {1.5f, 0.5f, 2f};
	    t.setWidths(widths);
	    t.setWidthPercentage(100F);  //设置表格宽度 100%
	    //大标题，用titleFont字体：20号字加粗
	    PdfPCell c1 = new PdfPCell(new Paragraph("志成散货", smtextFont));
	    c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
	    c1.setBorder(PdfPCell.BOTTOM);  //不要边框
	    c1.setColspan(3);
	    t.addCell(c1);

        c1 = new PdfPCell(); 
        c1.setBorder(PdfPCell.NO_BORDER); 
        c1.setFixedHeight(15); 
        c1.setColspan(3);
        t.addCell(c1);

        document.add(t);   //把表格t添加进document中
	}

    /**
     * 方法描述: 添加大标题和日期
     */
    private void addTopInfo(Document document, Font titleFont, Font textFont, Font smtextFont) throws DocumentException {
        //列数为1的表格
        PdfPTable t = new PdfPTable(3);
	    float[] widths = {1.5f, 0.5f, 2f};
	    t.setWidths(widths);
        t.setWidthPercentage(100F);  //设置表格宽度 100%
        
        PdfPCell c1 = new PdfPCell(new Paragraph("LINKEDNET FREIGHT", titleFont));
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        
        c1 = new PdfPCell();
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        

        c1 = new PdfPCell(new Paragraph("1404 BEDFORD OFFICE TOWER, BEDFORD CENTRE, 12 SMITH ROAD, BEDFORD GARDEN, JOHAN NESBURG ", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setVerticalAlignment(Element.ALIGN_CENTER);
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);

        c1 = new PdfPCell();
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);

        c1 = new PdfPCell();
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        
        c1 = new PdfPCell(new Paragraph("Tel no: 011-6151570 011-0297650", textFont));
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.NO_BORDER);  //不要边框
        t.addCell(c1);
        
        document.add(t);   //把表格t添加进document中
    }
    

    private void addEnd(Document document, Font keyFont, Font textFont) throws DocumentException
    {        
    	PdfPTable headTable = new PdfPTable(6);
	    float[] widths = {1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f};
	    headTable.setWidths(widths);
	    headTable.setWidthPercentage(80F);

        //加一行空行，设置高度，让标题和日期之间有点儿上下间距
        PdfPCell blankCell = new PdfPCell(); blankCell.setBorder(PdfPCell.NO_BORDER); blankCell.setFixedHeight(15); blankCell.setColspan(6); headTable.addCell(blankCell);

        PdfPCell c2Title = new PdfPCell(new Paragraph("Deliver Print name: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Receiver Print name: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Signature: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT);c2Title.setBorder(PdfPCell.NO_BORDER); headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Signature: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Phone no.: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Phone no.: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Date: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Date: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("", textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
	    
        document.add(headTable);   //把表格t添加进document中
    }
    

    /**
     * 方法描述: 添加大标题和日期
     */
    private void addDeliveryNoteTitleAndDateInfo(Document document, Font titleFont, Font keyFont) throws DocumentException {
        //列数为1的表格
        PdfPTable t = new PdfPTable(1);
        t.setWidthPercentage(100F);  //设置表格宽度 100%
        //大标题，用titleFont字体：20号字加粗
        PdfPCell c1 = new PdfPCell(new Paragraph("Delivery Note", titleFont));
        c1.setHorizontalAlignment(Element.ALIGN_CENTER); //水平居中
        c1.setBorder(PdfPCell.TOP);  //不要边框
        t.addCell(c1);
        document.add(t);   //把表格t添加进document中
    }
    
    private void addDeliveryNoteHeadField(Document document, IostDeliveryNote iostReceivingNote, Font keyFont, Font textFont) throws DocumentException
    {        
    	PdfPTable headTable = new PdfPTable(6);
	    float[] widths = {1.5f, 1.5f, 1.5f, 1.5f, 1.5f, 1.5f};
	    headTable.setWidths(widths);
	    headTable.setWidthPercentage(80F);

        //加一行空行，设置高度，让标题和日期之间有点儿上下间距
        PdfPCell blankCell = new PdfPCell(); blankCell.setBorder(PdfPCell.NO_BORDER); blankCell.setFixedHeight(15); blankCell.setColspan(6); headTable.addCell(blankCell);

        PdfPCell c2Title = new PdfPCell(new Paragraph("Contact Name: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_RIGHT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getContactName(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Date: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_RIGHT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(iostReceivingNote.getCreateTime());
        c2Title = new PdfPCell(new Paragraph(dateString, textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Phone No.: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_RIGHT);c2Title.setBorder(PdfPCell.NO_BORDER); headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getPhoneNo(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Reference: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_RIGHT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getReference(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(2); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Company: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_RIGHT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getCompany(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(5); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Address: ", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_RIGHT); c2Title.setBorder(PdfPCell.NO_BORDER);headTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph(iostReceivingNote.getAddress(), textFont)); c2Title.setHorizontalAlignment(Element.ALIGN_LEFT); c2Title.setColspan(5); c2Title.setBorder(PdfPCell.BOTTOM);headTable.addCell(c2Title);
	    
        document.add(headTable);   //把表格t添加进document中
    }
    

    /**
     * 增加单据体信息
     * @param document
     * @param iostReceivingNoteLists
     * @param keyFont
     * @param textFont
     * @throws DocumentException
     */
    private void addDeliveryNoteEntryTable(Document document, List<IostDeliveryNoteList> iostReceivingNoteLists, Font keyFont, Font textFont) throws DocumentException {
        PdfPTable entryTable = new PdfPTable(8);
        float[] widths = {2f, 1f, 1f, 1f, 1f, 1f, 1f, 1f};
        entryTable.setWidths(widths);
        entryTable.setWidthPercentage(80F);

        //加一行空行，设置高度，让标题和日期之间有点儿上下间距
        PdfPCell blankCell = new PdfPCell(); blankCell.setBorder(PdfPCell.NO_BORDER); blankCell.setFixedHeight(15); blankCell.setColspan(8); entryTable.addCell(blankCell);
        //设置表头
        PdfPCell c2Title = new PdfPCell(new Paragraph("Description", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("CTNS", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Length", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Width", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Height", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("CBM", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("Weight(kg)", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);
        c2Title = new PdfPCell(new Paragraph("MARK", keyFont)); c2Title.setHorizontalAlignment(Element.ALIGN_CENTER); entryTable.addCell(c2Title);

        int ctnses = 0;
        double cbms = 0;
        double weights = 0;
        //设置表内容
        for (int i = 0; i < iostReceivingNoteLists.size(); i++) {
        	IostDeliveryNoteList iostReceivingNoteList = iostReceivingNoteLists.get(i);

            PdfPCell c2 = new PdfPCell(new Paragraph(iostReceivingNoteList.getDescription() ==null?"" : iostReceivingNoteList.getDescription(), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
            

            if(iostReceivingNoteList.getCtns() != null)
            {
                ctnses += iostReceivingNoteList.getCtns();
            }
            c2 = new PdfPCell(new Paragraph(iostReceivingNoteList.getCtns() == null?"" : iostReceivingNoteList.getCtns().toString(), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);


            c2 = new PdfPCell(new Paragraph(iostReceivingNoteList.getLength() ==null? "0" : iostReceivingNoteList.getLength().toString(), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);


            c2 = new PdfPCell(new Paragraph(iostReceivingNoteList.getWidth() ==null?"0" : iostReceivingNoteList.getWidth().toString(), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);


            c2 = new PdfPCell(new Paragraph(iostReceivingNoteList.getHeight() ==null?"0" : iostReceivingNoteList.getHeight().toString(), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
            

            Double cbm = 0.0;
            if(iostReceivingNoteList.getCbm() != null)
            {
                cbms += iostReceivingNoteList.getCbm();
                cbm = iostReceivingNoteList.getCbm();
            }
            c2 = new PdfPCell(new Paragraph(String.format("%.2f", cbm), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);


            Double weight = 0.0;
            if(iostReceivingNoteList.getWeight() != null)
            {
                weights += iostReceivingNoteList.getWeight();
                weight = iostReceivingNoteList.getWeight();
            }
            c2 = new PdfPCell(new Paragraph(String.format("%.2f", weight), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);


            c2 = new PdfPCell(new Paragraph(iostReceivingNoteList.getMark() == null?"":iostReceivingNoteList.getMark(), textFont)); 
            c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
            entryTable.addCell(c2);
        }
        
        

        PdfPCell c2 = new PdfPCell(new Paragraph("Total", textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);
        

        c2 = new PdfPCell(new Paragraph(String.valueOf(ctnses), textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);


        c2 = new PdfPCell(new Paragraph("", textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);


        c2 = new PdfPCell(new Paragraph("", textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);


        c2 = new PdfPCell(new Paragraph("", textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);
        

        c2 = new PdfPCell(new Paragraph(String.format("%.2f", cbms), textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);


        c2 = new PdfPCell(new Paragraph(String.format("%.2f", weights), textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);


        c2 = new PdfPCell(new Paragraph("", textFont)); 
        c2.setHorizontalAlignment(Element.ALIGN_CENTER);  
        entryTable.addCell(c2);
        //添加统计数据表
        document.add(entryTable);
    }
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "delivery note-通过id删除")
	@ApiOperation(value="delivery note-通过id删除", notes="delivery note-通过id删除")
	@DeleteMapping(value = "/delete")
	@RequiresPermissions("deliveryNote:delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostDeliveryNoteService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "delivery note-批量删除")
	@ApiOperation(value="delivery note-批量删除", notes="delivery note-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	@RequiresPermissions("deliveryNote:delete")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostDeliveryNoteService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "delivery note-通过id查询")
	@ApiOperation(value="delivery note-通过id查询", notes="delivery note-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostDeliveryNote iostDeliveryNote = iostDeliveryNoteService.getById(id);
		if(iostDeliveryNote==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostDeliveryNote);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "delivery_note_list通过主表ID查询")
	@ApiOperation(value="delivery_note_list主表ID查询", notes="delivery_note_list-通主表ID查询")
	@GetMapping(value = "/queryIostDeliveryNoteListByMainId")
	public Result<?> queryIostDeliveryNoteListListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostDeliveryNoteList> iostDeliveryNoteListList = iostDeliveryNoteListService.selectByMainId(id);
		return Result.OK(iostDeliveryNoteListList);
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "delivery_note_list通过主表ID查询(包括统计)")
	@ApiOperation(value="delivery_note_list主表ID查询(包括统计)", notes="delivery_note_list-通主表ID查询(包括统计)")
	@GetMapping(value = "/queryIostDeliveryNoteListByMainIdWithSum")
	public Result<?> queryIostDeliveryNoteListListByMainIdWithSum(@RequestParam(name="id",required=true) String id) {
		List<IostDeliveryNoteList> iostDeliveryNoteListList = iostDeliveryNoteListService.selectByMainId(id);
		double totleWeight=0;
		for(IostDeliveryNoteList iostDeliveryNote: iostDeliveryNoteListList)
		{
			totleWeight = totleWeight + iostDeliveryNote.getWeight();
		}
		IostDeliveryNoteList iostDeliveryNoteList = new IostDeliveryNoteList();
		iostDeliveryNoteList.setDescription("Total");
		iostDeliveryNoteList.setWeight(totleWeight);
		iostDeliveryNoteListList.add(iostDeliveryNoteList);
		return Result.OK(iostDeliveryNoteListList);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostDeliveryNote
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostDeliveryNote iostDeliveryNote) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostDeliveryNote> queryWrapper = QueryGenerator.initQueryWrapper(iostDeliveryNote, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostDeliveryNote> queryList = iostDeliveryNoteService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostDeliveryNote> iostDeliveryNoteList = new ArrayList<IostDeliveryNote>();
      if(oConvertUtils.isEmpty(selections)) {
          iostDeliveryNoteList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostDeliveryNoteList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostDeliveryNotePage> pageList = new ArrayList<IostDeliveryNotePage>();
      for (IostDeliveryNote main : iostDeliveryNoteList) {
          IostDeliveryNotePage vo = new IostDeliveryNotePage();
          BeanUtils.copyProperties(main, vo);
          List<IostDeliveryNoteList> iostDeliveryNoteListList = iostDeliveryNoteListService.selectByMainId(main.getId());
          vo.setIostDeliveryNoteListList(iostDeliveryNoteListList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "delivery note列表");
      mv.addObject(NormalExcelConstants.CLASS, IostDeliveryNotePage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("delivery note数据", "导出人:"+sysUser.getRealname(), "delivery note"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostDeliveryNotePage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostDeliveryNotePage.class, params);
              for (IostDeliveryNotePage page : list) {
                  IostDeliveryNote po = new IostDeliveryNote();
                  BeanUtils.copyProperties(page, po);
                  iostDeliveryNoteService.saveMain(po, page.getIostDeliveryNoteListList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
