package org.jeecg.modules.iost.basedata.controller;

import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecg.modules.iost.basedata.entity.*;
import org.jeecg.modules.iost.basedata.vo.IostSummarySheetPage;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.vo.IostDeliveryRecordPage;
import org.jeecg.modules.iost.basedata.vo.IostReceivingPage;
import org.jeecg.modules.iost.basedata.service.IIostDeliveryRecordService;
import org.jeecg.modules.iost.basedata.service.IIostReceivinglistService;
import org.jeecg.modules.iost.basedata.service.IIostDeliveryRecordListService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 出库记录
 * @Author: jeecg-boot
 * @Date:   2020-12-07
 * @Version: V1.0
 */
@Api(tags="出库记录")
@RestController
@RequestMapping("/basedata/iostDeliveryRecord")
@Slf4j
public class IostDeliveryRecordController {
	@Autowired
	private IIostDeliveryRecordService iostDeliveryRecordService;
	@Autowired
	private IIostDeliveryRecordListService iostDeliveryRecordListService;
	@Autowired
	private IIostReceivinglistService iostReceivingList;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostDeliveryRecord
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "出库记录-分页列表查询")
	@ApiOperation(value="出库记录-分页列表查询", notes="出库记录-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostDeliveryRecord iostDeliveryRecord,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostDeliveryRecord> queryWrapper = QueryGenerator.initQueryWrapper(iostDeliveryRecord, req.getParameterMap());
		Page<IostDeliveryRecord> page = new Page<IostDeliveryRecord>(pageNo, pageSize);
		IPage<IostDeliveryRecord> pageList = iostDeliveryRecordService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostDeliveryRecordPage
	 * @return
	 */
	@AutoLog(value = "出库记录-添加")
	@ApiOperation(value="出库记录-添加", notes="出库记录-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostDeliveryRecordPage iostDeliveryRecordPage) {

		RemoveEmptyRow(iostDeliveryRecordPage);
		sum(iostDeliveryRecordPage);
		IostDeliveryRecord iostDeliveryRecord = new IostDeliveryRecord();
		BeanUtils.copyProperties(iostDeliveryRecordPage, iostDeliveryRecord);
		List<IostDeliveryRecordList> iostDeliveryRecordListList = iostDeliveryRecordPage.getIostDeliveryRecordListList();
		List<String> sourceEntryIds = getSourceEntryIds(iostDeliveryRecordListList);
		
		List<String> results = verifyOverfulfilledForNew(iostDeliveryRecordListList);
		if(results.size() > 0)
		{
			return Result.error("第(" + String.join(",", results) + ")行出现超额情况，请修改后再保存！");
		}
		
		iostDeliveryRecordService.saveMain(iostDeliveryRecord, iostDeliveryRecordListList);
		updateSourceEntryKeyFields(iostDeliveryRecord.getId(), sourceEntryIds);
		return Result.OK("添加成功！");
	}
	
	private void RemoveEmptyRow(IostDeliveryRecordPage iostDeliveryRecordPage)
	{
		List<IostDeliveryRecordList> iostDeliveryRecordListList = iostDeliveryRecordPage.getIostDeliveryRecordListList();
		
		List<IostDeliveryRecordList> iostDeliveryRecordListList_left = new ArrayList<IostDeliveryRecordList>();
		for(IostDeliveryRecordList iostDeliveryRecordList:iostDeliveryRecordListList)
		{
			if(iostDeliveryRecordList.getReceivingNo() == null) continue;
			if(iostDeliveryRecordList.getReceivingNo().trim().isEmpty()) continue;
			
			iostDeliveryRecordListList_left.add(iostDeliveryRecordList);
		}
		
		iostDeliveryRecordPage.setIostDeliveryRecordListList(iostDeliveryRecordListList_left);
	}
	
	/**
	 * 判断是否超额
	 * @param iostDeliveryRecordListList
	 * @return
	 */
	private List<String> verifyOverfulfilledForNew(List<IostDeliveryRecordList> iostDeliveryRecordListList)
	{
		List<String> results = new ArrayList<String>();
		List<String> sourceEntryIds = getSourceEntryIds(iostDeliveryRecordListList);
		List<DeliverySumSourceField> deliverySumSourceFields = iostDeliveryRecordListService.getSumSourceFields(sourceEntryIds);
		HashMap<String, Integer> deliveryCasesDic = new HashMap<String, Integer>();
		HashMap<String, String> deliveryRowsDic = new HashMap<String, String>();
		for(IostDeliveryRecordList iostDeliveryRecordList:iostDeliveryRecordListList)
		{
			int curIndex = iostDeliveryRecordListList.indexOf(iostDeliveryRecordList) + 1;
			String id = iostDeliveryRecordList.getSourceEntryId();
			Integer curCases = iostDeliveryRecordList.getCasesActual();
			if(curCases == null) curCases = 0;
			if(deliveryCasesDic.containsKey(id))
			{
				Integer cases = deliveryCasesDic.get(id);
				deliveryCasesDic.replace(id, cases + curCases);
			}
			else
			{
				deliveryCasesDic.put(id, curCases);
			}

			if(deliveryRowsDic.containsKey(id))
			{
				String indexs = deliveryRowsDic.get(id);
				deliveryRowsDic.replace(id, indexs + "," + curIndex);
			}
			else
			{
				deliveryRowsDic.put(id, String.valueOf(curIndex));
			}
		}
		
		for(DeliverySumSourceField deliverySumSourceField:deliverySumSourceFields)
		{
			String id = deliverySumSourceField.getSourceEntryId();
			if(!deliveryCasesDic.containsKey(id)) continue;
			if(deliveryCasesDic.get(id) <= deliverySumSourceField.getCases()) continue;
			
			results.add(deliveryRowsDic.get(id));
		}
		
		return results;
	}

	/**
	 * 判断是否超额
	 * @param iostDeliveryRecordListList
	 * @return
	 */
	private List<String> verifyOverfulfilledForEdit(List<IostDeliveryRecordList> newIostDeliveryRecordListList, String mainId )
	{

		List<IostDeliveryRecordList> oldIostDeliveryRecordListList = iostDeliveryRecordListService.selectByMainId(mainId);
		HashMap<String, Integer> oldDeliveryCasesDic = new HashMap<String, Integer>();
		for(IostDeliveryRecordList oldIostDeliveryRecordList:oldIostDeliveryRecordListList)
		{
			String id = oldIostDeliveryRecordList.getSourceEntryId();
			Integer curCases = oldIostDeliveryRecordList.getCasesActual();
			if(curCases == null) curCases = 0;
			if(oldDeliveryCasesDic.containsKey(id))
			{
				Integer cases = oldDeliveryCasesDic.get(id);
				oldDeliveryCasesDic.replace(id, cases + curCases);
			}
			else
			{
				oldDeliveryCasesDic.put(id, curCases);
			}
		}
		
		List<String> results = new ArrayList<String>();
		List<String> sourceEntryIds = getSourceEntryIds(newIostDeliveryRecordListList);
		List<DeliverySumSourceField> deliverySumSourceFields = iostDeliveryRecordListService.getSumSourceFields(sourceEntryIds);
		HashMap<String, Integer> deliveryCasesDic = new HashMap<String, Integer>();
		HashMap<String, String> deliveryRowsDic = new HashMap<String, String>();
		for(IostDeliveryRecordList iostDeliveryRecordList:newIostDeliveryRecordListList)
		{
			int curIndex = newIostDeliveryRecordListList.indexOf(iostDeliveryRecordList) + 1;
			String id = iostDeliveryRecordList.getSourceEntryId();
			Integer curCases = iostDeliveryRecordList.getCasesActual();
			if(curCases == null) curCases = 0;
			if(deliveryCasesDic.containsKey(id))
			{
				Integer cases = deliveryCasesDic.get(id);
				deliveryCasesDic.replace(id, cases + curCases);
			}
			else
			{
				deliveryCasesDic.put(id, curCases);
			}

			if(deliveryRowsDic.containsKey(id))
			{
				String indexs = deliveryRowsDic.get(id);
				deliveryRowsDic.replace(id, indexs + "," + curIndex);
			}
			else
			{
				deliveryRowsDic.put(id, String.valueOf(curIndex));
			}
		}
		
		for(DeliverySumSourceField deliverySumSourceField:deliverySumSourceFields)
		{
			String id = deliverySumSourceField.getSourceEntryId();
			if(!deliveryCasesDic.containsKey(id)) continue;
			int newCases = deliveryCasesDic.get(id);
			int leftCases = deliverySumSourceField.getCases();
			int oldCases = 0;
			
			if(oldDeliveryCasesDic.containsKey(id))
			{
				oldCases = oldDeliveryCasesDic.get(id);
			}
			
			if(newCases - oldCases <= leftCases) continue;
			
			results.add(deliveryRowsDic.get(id));
		}
		
		return results;
	}

	private void sum(IostDeliveryRecordPage iostDeliveryRecordPage)
	{
		List<IostDeliveryRecordList> iostDeliveryRecordLists = iostDeliveryRecordPage.getIostDeliveryRecordListList();
		iostDeliveryRecordPage.setVolumeTotals(0.0);
		iostDeliveryRecordPage.setWeightTotals(0.0);
		iostDeliveryRecordPage.setPackagesTotals(0);
		iostDeliveryRecordPage.setMoneyTotal(0.0);
		
		for(IostDeliveryRecordList iostDeliveryRecordList:iostDeliveryRecordLists)
		{
			double volumesTotal = 0;
			if(iostDeliveryRecordPage.getVolumeTotals() != null)
			{
				volumesTotal = iostDeliveryRecordPage.getVolumeTotals();
			}
			double weightsTotal = 0;
			if(iostDeliveryRecordPage.getWeightTotals() != null)
			{
				weightsTotal = iostDeliveryRecordPage.getWeightTotals();
			}
			
			int packagesTotals = 0;
			if(iostDeliveryRecordPage.getPackagesTotals() != null)
			{
				packagesTotals = iostDeliveryRecordPage.getPackagesTotals();
			}

			double moneyTotal = 0;
			if(iostDeliveryRecordPage.getMoneyTotal() != null)
			{
				moneyTotal = iostDeliveryRecordPage.getMoneyTotal();
			}
			
			double singleVolumeTotal = 0;
			if(iostDeliveryRecordList.getVolumeTotal() != null)
			{
				singleVolumeTotal = iostDeliveryRecordList.getVolumeTotal();
			}

			double singleWeightsTotal = 0;
			if(iostDeliveryRecordList.getWeightTotal() != null)
			{
				singleWeightsTotal = iostDeliveryRecordList.getWeightTotal();
			}
			
			int packagesTotal = 0;
			if(iostDeliveryRecordList.getCasesActual() != null)
			{
				packagesTotal = iostDeliveryRecordList.getCasesActual();
			}
			
			double money = 0;
			if(iostDeliveryRecordList.getMoney() != null)
			{
				money = iostDeliveryRecordList.getMoney();
			}
			
			iostDeliveryRecordPage.setVolumeTotals(volumesTotal + singleVolumeTotal);
			iostDeliveryRecordPage.setWeightTotals(weightsTotal + singleWeightsTotal);
			iostDeliveryRecordPage.setPackagesTotals(packagesTotals + packagesTotal);
			iostDeliveryRecordPage.setMoneyTotal(moneyTotal + money);
		}
	}
	
	
	/**
	 *  编辑
	 *
	 * @param iostDeliveryRecordPage
	 * @return
	 */
	@AutoLog(value = "出库记录-编辑")
	@ApiOperation(value="出库记录-编辑", notes="出库记录-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostDeliveryRecordPage iostDeliveryRecordPage) {

		RemoveEmptyRow(iostDeliveryRecordPage);
		sum(iostDeliveryRecordPage);
		IostDeliveryRecord iostDeliveryRecord = new IostDeliveryRecord();
		BeanUtils.copyProperties(iostDeliveryRecordPage, iostDeliveryRecord);
		IostDeliveryRecord iostDeliveryRecordEntity = iostDeliveryRecordService.getById(iostDeliveryRecord.getId());
		if(iostDeliveryRecordEntity==null) {
			return Result.error("未找到对应数据");
		}

		List<String> results = verifyOverfulfilledForEdit(iostDeliveryRecordPage.getIostDeliveryRecordListList(), iostDeliveryRecord.getId());
		if(results.size() > 0)
		{
			return Result.error("第(" + String.join(",", results) + ")行出现超额情况，请修改后再保存！");
		}
		List<String> sourceEntryIds = getSourceEntryIds(iostDeliveryRecord.getId());
		iostDeliveryRecordService.updateMain(iostDeliveryRecord, iostDeliveryRecordPage.getIostDeliveryRecordListList());
		updateSourceEntryKeyFields(iostDeliveryRecord.getId(), sourceEntryIds);
		return Result.OK("编辑成功!");
	}
	
	/**
	 * 反写源单关键信息
	 * @param sourceEntryIds
	 */
	private void updateSourceEntryKeyFields(String mainId, List<String> sourceEntryIds)
	{
		if(sourceEntryIds == null)
		{
			sourceEntryIds = new ArrayList<String>();
			sourceEntryIds.add("");
		}
		iostReceivingList.writebackFromDelivery(mainId, sourceEntryIds);
		iostReceivingList.ClearFromDelivery(sourceEntryIds);
	}
	
	/**
	 * 获取所有的源单单据体ID
	 * @param mainId
	 * @return
	 */
	private List<String> getSourceEntryIds(String mainId)
	{
		List<IostDeliveryRecordList> iostDeliveryRecordListList = iostDeliveryRecordListService.selectByMainId(mainId);

		return getSourceEntryIds(iostDeliveryRecordListList);
	}
	
	/**
	 * 获取所有的源单单据体ID
	 * @param iostDeliveryRecordListList
	 * @return
	 */
	private List<String> getSourceEntryIds(List<IostDeliveryRecordList> iostDeliveryRecordListList)
	{
		List<String> sourceEntryIds = new ArrayList<String>();
		sourceEntryIds.add("");
		for(IostDeliveryRecordList iostDeliveryRecordList:iostDeliveryRecordListList)
		{
			String sourceEntryId = iostDeliveryRecordList.getSourceEntryId();
			if(sourceEntryId != null && !sourceEntryId.isEmpty())
			{
				sourceEntryIds.add(sourceEntryId);
			}
		}
		return sourceEntryIds;
	}
	
	/**
	 *   通过id删除
	 *
	 * @param
	 * @return
	 */
	@AutoLog(value = "出库记录-通过id删除")
	@ApiOperation(value="出库记录-通过id删除", notes="出库记录-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		List<String> sourceEntryIds = getSourceEntryIds(id);
		iostDeliveryRecordService.delMain(id);
		updateSourceEntryKeyFields(id, sourceEntryIds);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "出库记录-批量删除")
	@ApiOperation(value="出库记录-批量删除", notes="出库记录-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		List<String> idList = Arrays.asList(ids.split(","));
		List<String> sourceEntryIds = new ArrayList<String>();
		sourceEntryIds.add("");
		for(String id:idList)
		{
			List<String> sourceEntryIdList = getSourceEntryIds(id);
			for(String sourceEntryId:sourceEntryIdList)
			{
				sourceEntryIds.add(sourceEntryId);
			}
		}
		
		this.iostDeliveryRecordService.delBatchMain(idList);
		updateSourceEntryKeyFields("", sourceEntryIds);
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "出库记录-通过id查询")
	@ApiOperation(value="出库记录-通过id查询", notes="出库记录-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostDeliveryRecord iostDeliveryRecord = iostDeliveryRecordService.getById(id);
		if(iostDeliveryRecord==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostDeliveryRecord);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "出库记录表通过主表ID查询")
	@ApiOperation(value="出库记录表主表ID查询", notes="出库记录表-通主表ID查询")
	@GetMapping(value = "/queryIostDeliveryRecordListByMainId")
	public Result<?> queryIostDeliveryRecordListListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostDeliveryRecordList> iostDeliveryRecordListList = iostDeliveryRecordListService.selectByMainId(id);
		return Result.OK(iostDeliveryRecordListList);
	}

	 /***
	  * 增加统计行
	  * @param pageList
	  */
	 private IostDeliveryRecordPage addSumRow(List<IostDeliveryRecordPage> pageList)
	 {
		 IostDeliveryRecordPage iostDeliveryRecord = new IostDeliveryRecordPage();
		 List<IostDeliveryRecordList> iostDeliveryRecordLists = new ArrayList<>();
		 double totlevolume = 0;//体积总
		 int totlepackagesTotals = 0;//件数总
		 double totleweightTotals = 0;//重量总
		 double totleMoney = 0;//金额总
		 double totlevolumeList = 0;//体积总
		 int totlepackagesTotalsList = 0;//件数总
		 double totleweightTotalsList = 0;//重量总
		 double totleMoneyList = 0;//金额总
	 	for (IostDeliveryRecordPage iostDeliveryRecordPage:pageList){
	 		for(IostDeliveryRecordList iostDeliveryRecordList :iostDeliveryRecordPage.getIostDeliveryRecordListList()){
					BigDecimal A1;
					BigDecimal A2;
					if(iostDeliveryRecordList.getVolumeTotal()!=null){
						A1 = new BigDecimal(Double.toString(totlevolumeList));
						A2 = new BigDecimal(Double.toString(iostDeliveryRecordList.getVolumeTotal()));
						totlevolumeList = A1.add(A2).doubleValue();
					}
					if(iostDeliveryRecordList.getWeightTotal()!=null){
						A1 = new BigDecimal(Double.toString(totleweightTotalsList));
						A2 = new BigDecimal(Double.toString(iostDeliveryRecordList.getWeightTotal()));
						totleweightTotalsList = A1.add(A2).doubleValue();
					}
					if(iostDeliveryRecordList.getWeightTotal()!=null){
						totlepackagesTotalsList = totlepackagesTotalsList + iostDeliveryRecordList.getPackagesTotal();
					}
					if(iostDeliveryRecordList.getMoney()!=null){
						A1 = new BigDecimal(Double.toString(totleMoneyList));
						A2 = new BigDecimal(Double.toString(iostDeliveryRecordList.getMoney()));
						totleMoneyList = A1.add(A2).doubleValue();
					}
				}
			BigDecimal A1;
			BigDecimal A2;
			if(iostDeliveryRecordPage.getVolumeTotals()!=null){
				A1 = new BigDecimal(Double.toString(totlevolumeList));
				A2 = new BigDecimal(Double.toString(iostDeliveryRecordPage.getVolumeTotals()));
				totlevolume = A1.add(A2).doubleValue();
			}
			if(iostDeliveryRecordPage.getWeightTotals()!=null){
				A1 = new BigDecimal(Double.toString(totleweightTotalsList));
				A2 = new BigDecimal(Double.toString(iostDeliveryRecordPage.getWeightTotals()));
				totleweightTotals= A1.add(A2).doubleValue();
			}
			if(iostDeliveryRecordPage.getWeightTotals()!=null){
				totlepackagesTotals = totlepackagesTotalsList + iostDeliveryRecordPage.getPackagesTotals();
			}
			if(iostDeliveryRecordPage.getMoneyTotal()!=null){
				A1 = new BigDecimal(Double.toString(totleMoneyList));
				A2 = new BigDecimal(Double.toString(iostDeliveryRecordPage.getMoneyTotal()));
				totleMoney = A1.add(A2).doubleValue();
			}
		}
	 	//List<IostDeliveryRecordList>
		 IostDeliveryRecordList iostDeliveryRecord1 = new IostDeliveryRecordList();
		 iostDeliveryRecord1.setVolumeTotal(totlevolumeList);
		 iostDeliveryRecord1.setWeightTotal(totleweightTotalsList);
		 iostDeliveryRecord1.setPackagesTotal(totlepackagesTotalsList);
		 iostDeliveryRecord1.setMoney(totleMoneyList);
		 iostDeliveryRecordLists.add(iostDeliveryRecord1);
		 //IostDeliveryRecordPage
	 	iostDeliveryRecord.setBulkNo("总行");
		 iostDeliveryRecord.setVolumeTotals(totlevolume);
		 iostDeliveryRecord.setWeightTotals(totleweightTotals);
		 iostDeliveryRecord.setPackagesTotals(totlepackagesTotals);
		 iostDeliveryRecord.setMoneyTotal(totleMoney);
		 iostDeliveryRecord.setIostDeliveryRecordListList(iostDeliveryRecordLists);
	 	 return iostDeliveryRecord;
	 }

    /**
    * 导出excel
    *
    * @param request
    * @param iostDeliveryRecord
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostDeliveryRecord iostDeliveryRecord) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostDeliveryRecord> queryWrapper = QueryGenerator.initQueryWrapper(iostDeliveryRecord, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostDeliveryRecord> queryList = iostDeliveryRecordService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostDeliveryRecord> iostDeliveryRecordList = new ArrayList<IostDeliveryRecord>();
      if(oConvertUtils.isEmpty(selections)) {
          iostDeliveryRecordList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostDeliveryRecordList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostDeliveryRecordPage> pageList = new ArrayList<IostDeliveryRecordPage>();
      for (IostDeliveryRecord main : iostDeliveryRecordList) {
          IostDeliveryRecordPage vo = new IostDeliveryRecordPage();
          BeanUtils.copyProperties(main, vo);
          List<IostDeliveryRecordList> iostDeliveryRecordListList = iostDeliveryRecordListService.selectByMainId(main.getId());
          vo.setIostDeliveryRecordListList(iostDeliveryRecordListList);
          pageList.add(vo);
      }
      //添加总数行
		pageList.add(addSumRow(pageList));
      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "出库记录列表");
      mv.addObject(NormalExcelConstants.CLASS, IostDeliveryRecordPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("出库记录数据", "导出人:"+sysUser.getRealname(), "出库记录"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostDeliveryRecordPage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostDeliveryRecordPage.class, params);
              for (IostDeliveryRecordPage page : list) {
                  IostDeliveryRecord po = new IostDeliveryRecord();
                  BeanUtils.copyProperties(page, po);
                  iostDeliveryRecordService.saveMain(po, page.getIostDeliveryRecordListList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
