package org.jeecg.modules.iost.basedata.controller;

import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.vo.LoginUser;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.basedata.entity.IostInsurancePolicyList;
import org.jeecg.modules.iost.basedata.entity.IostDeliveryNoteList;
import org.jeecg.modules.iost.basedata.entity.IostInsurancePolicy;
import org.jeecg.modules.iost.basedata.vo.IostInsurancePolicyPage;
import org.jeecg.modules.iost.basedata.service.IIostInsurancePolicyService;
import org.jeecg.modules.iost.basedata.service.IIostInsurancePolicyListService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 保险单
 * @Author: jeecg-boot
 * @Date:   2020-11-20
 * @Version: V1.0
 */
@Api(tags="保险单")
@RestController
@RequestMapping("/basedata/iostInsurancePolicy")
@Slf4j
public class IostInsurancePolicyController {
	@Autowired
	private IIostInsurancePolicyService iostInsurancePolicyService;
	@Autowired
	private IIostInsurancePolicyListService iostInsurancePolicyListService;
	
	/**
	 * 分页列表查询
	 *
	 * @param iostInsurancePolicy
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "保险单-分页列表查询")
	@ApiOperation(value="保险单-分页列表查询", notes="保险单-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(IostInsurancePolicy iostInsurancePolicy,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<IostInsurancePolicy> queryWrapper = QueryGenerator.initQueryWrapper(iostInsurancePolicy, req.getParameterMap());
		Page<IostInsurancePolicy> page = new Page<IostInsurancePolicy>(pageNo, pageSize);
		IPage<IostInsurancePolicy> pageList = iostInsurancePolicyService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param iostInsurancePolicyPage
	 * @return
	 */
	@AutoLog(value = "保险单-添加")
	@ApiOperation(value="保险单-添加", notes="保险单-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody IostInsurancePolicyPage iostInsurancePolicyPage) {
		IostInsurancePolicy iostInsurancePolicy = new IostInsurancePolicy();
		BeanUtils.copyProperties(iostInsurancePolicyPage, iostInsurancePolicy);
		iostInsurancePolicyService.saveMain(iostInsurancePolicy, iostInsurancePolicyPage.getIostInsurancePolicyListList());
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param iostInsurancePolicyPage
	 * @return
	 */
	@AutoLog(value = "保险单-编辑")
	@ApiOperation(value="保险单-编辑", notes="保险单-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody IostInsurancePolicyPage iostInsurancePolicyPage) {
		IostInsurancePolicy iostInsurancePolicy = new IostInsurancePolicy();
		BeanUtils.copyProperties(iostInsurancePolicyPage, iostInsurancePolicy);
		IostInsurancePolicy iostInsurancePolicyEntity = iostInsurancePolicyService.getById(iostInsurancePolicy.getId());
		if(iostInsurancePolicyEntity==null) {
			return Result.error("未找到对应数据");
		}
		iostInsurancePolicyService.updateMain(iostInsurancePolicy, iostInsurancePolicyPage.getIostInsurancePolicyListList());
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "保险单-通过id删除")
	@ApiOperation(value="保险单-通过id删除", notes="保险单-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		iostInsurancePolicyService.delMain(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "保险单-批量删除")
	@ApiOperation(value="保险单-批量删除", notes="保险单-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.iostInsurancePolicyService.delBatchMain(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "保险单-通过id查询")
	@ApiOperation(value="保险单-通过id查询", notes="保险单-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		IostInsurancePolicy iostInsurancePolicy = iostInsurancePolicyService.getById(id);
		if(iostInsurancePolicy==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(iostInsurancePolicy);

	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "保险明细通过主表ID查询")
	@ApiOperation(value="保险明细主表ID查询", notes="保险明细-通主表ID查询")
	@GetMapping(value = "/queryIostInsurancePolicyListListByMainId")
	public Result<?> queryIostInsurancePolicyListListByMainId(@RequestParam(name="id",required=true) String id) {
		List<IostInsurancePolicyList> iostInsurancePolicyListList = iostInsurancePolicyListService.selectByMainId(id);
		return Result.OK(iostInsurancePolicyListList);
	}
	

	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "保险明细通过主表ID查询")
	@ApiOperation(value="保险明细主表ID查询", notes="保险明细-通主表ID查询")
	@GetMapping(value = "/queryIostInsurancePolicyListByMainIdWithSum")
	public Result<?> queryIostInsurancePolicyListListByMainIdWithSum(@RequestParam(name="id",required=true) String id) {
		List<IostInsurancePolicyList> iostInsurancePolicyListList = iostInsurancePolicyListService.selectByMainId(id);
		double totleWeight=0;
		int totleVolume=0;
		double totleMoney =0;
		int totlePackages = 0;

		for(IostInsurancePolicyList iostInsurancePolicyList: iostInsurancePolicyListList)
		{
			totleWeight = totleWeight + iostInsurancePolicyList.getWeight();
			totleVolume = totleVolume + iostInsurancePolicyList.getVolume();
			totleMoney = totleMoney + iostInsurancePolicyList.getMoney();
			totlePackages = totlePackages + iostInsurancePolicyList.getPackages();
		}
		IostInsurancePolicyList iostInsurancePolicyList = new IostInsurancePolicyList();
		iostInsurancePolicyList.setName("Total");
		iostInsurancePolicyList.setWeight(totleWeight);
		iostInsurancePolicyList.setMoney(totleMoney);
		iostInsurancePolicyList.setVolume(totleVolume);
		iostInsurancePolicyList.setPackages(totlePackages);
		iostInsurancePolicyListList.add(iostInsurancePolicyList);
		return Result.OK(iostInsurancePolicyListList);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param iostInsurancePolicy
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, IostInsurancePolicy iostInsurancePolicy) {
      // Step.1 组装查询条件查询数据
      QueryWrapper<IostInsurancePolicy> queryWrapper = QueryGenerator.initQueryWrapper(iostInsurancePolicy, request.getParameterMap());
      LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

      //Step.2 获取导出数据
      List<IostInsurancePolicy> queryList = iostInsurancePolicyService.list(queryWrapper);
      // 过滤选中数据
      String selections = request.getParameter("selections");
      List<IostInsurancePolicy> iostInsurancePolicyList = new ArrayList<IostInsurancePolicy>();
      if(oConvertUtils.isEmpty(selections)) {
          iostInsurancePolicyList = queryList;
      }else {
          List<String> selectionList = Arrays.asList(selections.split(","));
          iostInsurancePolicyList = queryList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
      }

      // Step.3 组装pageList
      List<IostInsurancePolicyPage> pageList = new ArrayList<IostInsurancePolicyPage>();
      for (IostInsurancePolicy main : iostInsurancePolicyList) {
          IostInsurancePolicyPage vo = new IostInsurancePolicyPage();
          BeanUtils.copyProperties(main, vo);
          List<IostInsurancePolicyList> iostInsurancePolicyListList = iostInsurancePolicyListService.selectByMainId(main.getId());
          vo.setIostInsurancePolicyListList(iostInsurancePolicyListList);
          pageList.add(vo);
      }

      // Step.4 AutoPoi 导出Excel
      ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
      mv.addObject(NormalExcelConstants.FILE_NAME, "保险单列表");
      mv.addObject(NormalExcelConstants.CLASS, IostInsurancePolicyPage.class);
      mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("保险单数据", "导出人:"+sysUser.getRealname(), "保险单"));
      mv.addObject(NormalExcelConstants.DATA_LIST, pageList);
      return mv;
    }

    /**
    * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
      MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
      Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
      for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
          MultipartFile file = entity.getValue();// 获取上传文件对象
          ImportParams params = new ImportParams();
          params.setTitleRows(2);
          params.setHeadRows(1);
          params.setNeedSave(true);
          try {
              List<IostInsurancePolicyPage> list = ExcelImportUtil.importExcel(file.getInputStream(), IostInsurancePolicyPage.class, params);
              for (IostInsurancePolicyPage page : list) {
                  IostInsurancePolicy po = new IostInsurancePolicy();
                  BeanUtils.copyProperties(page, po);
                  iostInsurancePolicyService.saveMain(po, page.getIostInsurancePolicyListList());
              }
              return Result.OK("文件导入成功！数据行数:" + list.size());
          } catch (Exception e) {
              log.error(e.getMessage(),e);
              return Result.error("文件导入失败:"+e.getMessage());
          } finally {
              try {
                  file.getInputStream().close();
              } catch (IOException e) {
                  e.printStackTrace();
              }
          }
      }
      return Result.OK("文件导入失败！");
    }

}
